/***************************************************************************
 This file is Copyright (C) 2005 Christoph Reichenbach

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the
   Free Software Foundation, Inc.
   59 Temple Place, Suite 330
   Boston, MA  02111-1307
   USA

 The author can be reached as "reichenb" at "colorado.edu".

***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "readline.h"
#include <readline/readline.h>

/*extern char *rl_line_buffer;
extern char **(*rl_attempted_completion_function)(const char *, int, int);
extern char *rl_readline_name;*/

const int table_type_regular = 0;
const int table_type_number = 1;
const int tbale_type_string = 2;

static completion_table_t *completion_root_table = NULL;

void
indent (int i)
{
	while (i--)
		fprintf(stderr, "  ");
}

void
print_completion_table(completion_table_t *tbl, int ind)
{
	int i;

	indent (ind);
	if (tbl == NULL) {
		fprintf(stderr, "{<NULL> table}\n");
		return;
	}

	fprintf(stderr, "{t:%d", tbl->type);
	switch (tbl->type) {
	case 0: fprintf(stderr, " (regular)");
		break;

	case 1: fprintf(stderr, " (int)");
		break;

	case 2: fprintf(stderr, " (string)");
		break;

	default: break;
	}
	fprintf(stderr, "\n");
	indent (ind);
	fprintf(stderr, "[%d entries:\n", tbl->entries_nr);

	for (i = 0; i < tbl->entries_nr; i++) {
		indent (ind);
		fprintf(stderr, "'%s' =>\n", tbl->entries[i].string);
		print_completion_table(tbl->entries[i].next_table, ind+2);
	}
	indent(ind);
	fprintf(stderr, "_ =>\n");
	print_completion_table(tbl->next_table, ind+1);
	indent(ind);
	fprintf(stderr, "]}\n");
}

void
print_root_completion_table()
{
	print_completion_table (completion_root_table, 0);
}

void
set_readline_table(completion_table_t *table)
{
/* 	fprintf(stderr, "New completion table:\n");
 	print_completion_table(table, 0);*/
	completion_root_table = table;
}

/* Yes, this is not reentrant. */

/* static int completion_list_size = 0; */
/* static int completion_list_usage = 0; */
/* static char **completion_list = NULL; */

/* void */
/* reset_completion_list(void) */
/* { */
/* 	completion_list_usage = 0; */
/* 	if (completion_list == NULL) */
/* 		completion_list = calloc(sizeof(char*), completion_list_size = 32); */

/* 	completion_list[0] = NULL; */
/* } */

/* void */
/* add_completion(char *entry) */
/* { */
/* 	if (completion_list_usage + 1 == completion_list_size) */
/* 		completion_list = realloc(completion_list, sizeof(char*) * (completion_list_size += 16)); */

/* 	completion_list[completion_list_usage++] = entry; */
/* 	completion_list[completion_list_usage] = NULL; */
/* } */


char *
part_tokenise(char *buf, int maxlen, int *tokenlen)
{
	char *seeker;

	while (maxlen && isblank(*buf)) {
		--maxlen;
		++buf;
	}

	if (!maxlen)
		return NULL;

	seeker = buf;

	while (maxlen-- && !isblank(*seeker++));

	*tokenlen = seeker - buf - 1;
	return buf;
}

completion_table_t *
find_completion_table(completion_table_t *table, char *buf, int start)
{
	if (table == NULL)
		return NULL;
	else {
		int tokenlen;
		char *token = part_tokenise(buf, start, &tokenlen);

/*		fprintf(stderr, "Token = '%s'/%d\n", token, tokenlen); */

		if (!token) /* No token? */
			return table;

		start -= (token - buf); /* Adjust for offset of initial blanks */

		if (tokenlen == start)
			/* Finished */
			return table;
		else {
			/* Found a token, but we have to continue afterwards */
			if (table->type == table_type_regular) {
				int i;

				for (i = 0; i < table->entries_nr; i++)
					if (!(strncmp(table->entries[i].string, token, tokenlen))
					    && strlen(table->entries[i].string) == tokenlen)
						return find_completion_table(table->entries[i].next_table,
									     token + tokenlen,
									     start - tokenlen);
				/* Otherwise, continue to the default-next table */
			}
			/* For other table types or if we failed to locate a match */

			return find_completion_table(table->next_table,
						     token + tokenlen,
						     start - tokenlen);
		}
	}
}

void
print_completion_list(char **completions)
{
	int i = 0;
	fprintf(stderr, "Completions:\n");
	while (completions[i]) {
		fprintf(stderr, "\t'%s'\n", completions[i]);
		i++;
	}
	fprintf(stderr, "Total: %d\n", i);
}

static completion_table_t *my_static_completion_table;
static int my_static_completion_index;

char *
dup_string(const char *string)
{
	int len = strlen(string) + 1;
	char *dup = malloc(len);

	memcpy(dup, string, len);
	return dup;
}

char *
part_completer(const char *partname, int initial)
{
	completion_table_t *worktable = my_static_completion_table;
	int i;
	int len = strlen(partname);

	if (!worktable)
		return NULL;

	/* Add all completions we can find */
/* 	fprintf(stderr, " Now trying to complete '%s'\n", partname); */

	for (; my_static_completion_index < worktable->entries_nr;) {
		char *option = worktable->entries[my_static_completion_index++].string;

		if (!(strncmp(option, partname, len)))
			return dup_string(option);
	}

	return NULL;
}

char **
table_completer(const char *partname, int start, int end)
{
	my_static_completion_table = find_completion_table(completion_root_table, rl_line_buffer, start);
	my_static_completion_index = 0;

/* 	fprintf(stderr, "Completion table, based on '%s'/%d:\n", rl_line_buffer, start); */
/* 	print_completion_table(my_static_completion_table, 2); */

	return rl_completion_matches (partname, part_completer);
}

/* Based on the 'readline' info pages */

/* static char **(*completer)(const char *, int, int) = NULL; */

/* char ** */
/* universal_completer(char *_, int start, int end) */
/* { */
/* 	return completer(rl_line_buffer, start, end); */
/* } */

void
initialise_readline(char *procname)
{
	rl_readline_name = procname;
	rl_attempted_completion_function = table_completer;
}
