(***************************************************************************
 This file is Copyright (C) 2005 Christoph Reichenbach

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the
   Free Software Foundation, Inc.
   59 Temple Place, Suite 330
   Boston, MA  02111-1307
   USA

 The author can be reached as "reichenb" at "colorado.edu".

***************************************************************************)

structure ReadlineTest =
struct
      structure RL = Readline(val progname = ".test.")

      structure StringNum = RLMakeFiniteTableApp (structure AppList = struct
						  type t = int
						  val typename = "verbose integer"
						  val mappings = [("zero", 0),
								  ("one", 1),
								  ("two", 2)]
						  end)

      structure FixedMessage = RLMakeFiniteTableApp (structure AppList = struct
						  type t = string
						  val typename = "predefined string"
						  val mappings = [("hello", "hello\n"),
								  ("goodbye", "goodbye\n"),
								  ("foo", "foo\n")]
						  end)

      fun test () =
	  let
	      val done = ref false

	      fun f_quit () = (done := true)
	      fun f_add (x1 : int) (x2 : int) = x1 + x2
	      fun f_multiecho (count : int) (message : string) = if (count = 0)
								 then ()
								 else (print message;
								       f_multiecho (count - 1) message)
	      fun f_xor (true) (false)	= true
		| f_xor (false) (true)	= true
		| f_xor (_) (_)		= false
	      fun f_message1 () = "And now for something completely different."
	      fun f_message2 () = "ALL YOUR BASE ARE BELONG TO US"
	      fun f_message3 () = "Far out in the uncharted backwaters of the unfashionable end of the western spiral arm of the galaxy lies an unregarded yellow sun."
	      fun f_message4 () = "kono sekai wa... kusatte iru!"
	      fun f_message5 () = "Als Gregor Samsa eines Morgens aus unruhigen Traeumen erwachte, fand er sich in seinem Bette zu einem ungeheuren Ungeziefer verwandelt."
	      fun f_message6 () = "Call me Ishmael."
	      fun f_message7 () = "It was the best of times, it was the worst of times."
	      fun f_message8 () = "I am not a number, I'm a free man!"
	      fun f_message9 () = "Ich bin ein Berliner!"
	      fun f_message10 () = "A small step for man, a giant leap for humanity."
	      fun f_message11 () = "Der Worte sind genug gewechselt, lasst mich auch endlich Taten sehn-- indess ihr Komplimente drechselt koennt' etwas nuetzliches geschehn!"
	      fun f_message12 () = "Fly you fools!"
	      fun f_message13 () = "Nothing outruns Alpha!"
	      fun f_message14 () = "640k should be enough for anyone."
	      fun f_message15 () = "Also sprach Zarathustra."


	      val menu = RL.menu [RL.menu_item ((RLInt.rlfunc o RLInt.app o RLInt.app) (RL.rlfun ("addi", f_add))),
				  RL.menu_item ((RLInt.rlfunc o StringNum.app o RLInt.app) (RL.rlfun ("add", f_add))),
				  RL.menu_item ((RLBool.rlfunc o RLBool.app o RLBool.app) (RL.rlfun ("xor", f_xor))),
				  RL.menu_item ((RLUnit.rlfunc o FixedMessage.app o StringNum.app) (RL.rlfun ("multiecho", f_multiecho))),
				  RL.menu_item ((RLUnit.rlfunc o RLUnit.app) (RL.rlfun ("exit", f_quit))),
				  RL.sub_menu ("message", RL.menu (map
								       (fn p => RL.menu_item (RLString.rlfunc (RL.apply_const () (RL.rlfun p))))
								       [("1", f_message1),
									("2", f_message2),
									("3", f_message3),
									("4", f_message4),
									("5", f_message5),
									("6", f_message6),
									("7", f_message7),
									("8", f_message8),
									("9", f_message9),
									("10", f_message10),
									("11", f_message11),
									("12", f_message12),
									("13", f_message13),
									("14", f_message14),
									("15", f_message15)]))]
	  in
	      while (not (!done))
	      do let val input = RL.readline (">> ", menu)
		 in RL.process (input, menu)
		 end
	  end

      val _ = test() (* Start right away *)
end
