(***************************************************************************
 This file is Copyright (C) 2005 Christoph Reichenbach

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the
   Free Software Foundation, Inc.
   59 Temple Place, Suite 330
   Boston, MA  02111-1307
   USA

 The author can be reached as "reichenb" at "colorado.edu".

***************************************************************************)

structure ReadlineFoundation =
struct
      (* Base functionality for turning functions into contexts *)
      type 'a rlfun_ctx = { name	: string,
			    f		: string list -> (string list * int * 'a),
			    completions	: (unit -> string list) list }

      type rlfun = { name		: string,
		     function		: string list -> unit,
		     completions	: (unit -> string list) list }

end

signature READLINE_APP_TYPE =
sig
    type t				(* The type we hope to deal with *)

    val typename : string		(* A runtime-printable name for this type, used for error messages *)
    val read : string -> t option	(* Reads a token of the specified type or fails *)
    val completions : unit ->
		      string list	(* Any completions that are desired (typically the values
					 * accepted by 'read'); this is re-evaluated for every readline
					 * call *)
end

signature READLINE_RESULT_TYPE =
sig
    type t				(* The type we hope to deal with *)
    val print : t -> unit		(* Prints the specified type to stdout *)
end


(* The following signature describes what is generated by RLMakeAppResult *)
(* It's a combination of READLINE_APP and READLINE_RESULT, listed further down,
 * which are available separately. *)
signature READLINE_APP_RESULT =
sig
    structure App : READLINE_APP_TYPE
    structure Result : READLINE_RESULT_TYPE
    type t = App.t

    type 'a rlfun_ctx = 'a ReadlineFoundation.rlfun_ctx
    type rlfun = ReadlineFoundation.rlfun

    val app : ((t -> 'a) rlfun_ctx) -> 'a rlfun_ctx	(* Applies an rlfun_ctx to one argument
							 * of the type represented by this ReadlineAppType *)
    val rlfunc : t rlfun_ctx -> rlfun			(* Turns an rlfun_ctx into an rlfun after this
							 * rlfun_ctx is of the type represented here;
							 * this is achieved either if the rlfun_ctx is
							 * inherently merely a value, or if appropriate calls
							 * to "app" have been applied to the function before *)
end

(* The following signature describes what is generated by RLMakeApp *)
signature READLINE_APP =
sig
    structure App : READLINE_APP_TYPE
    type t = App.t

    type 'a rlfun_ctx = 'a ReadlineFoundation.rlfun_ctx
    type rlfun = ReadlineFoundation.rlfun

    val app : ((t -> 'a) rlfun_ctx) -> 'a rlfun_ctx
end

(* The following signature describes what is generated by RLMakeResult *)
signature READLINE_RESULT =
sig
    structure Result : READLINE_RESULT_TYPE
    type t = Result.t

    type 'a rlfun_ctx = 'a ReadlineFoundation.rlfun_ctx
    type rlfun = ReadlineFoundation.rlfun

    val rlfunc : t rlfun_ctx -> rlfun
end

