(***************************************************************************
 This file is Copyright (C) 2005 Christoph Reichenbach

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the
   Free Software Foundation, Inc.
   59 Temple Place, Suite 330
   Boston, MA  02111-1307
   USA

 The author can be reached as "reichenb" at "colorado.edu".

***************************************************************************)

(* Version: 0.1.3 *)

(* Base functionality for the 'Readline' interface:
 * - Build menus
 * - Build submenus
 * - Build rlfun_ctx values
 * - Integrate rlfuns into menus
 * - Actually call 'readline'
 *
 * Note that rlfun_ctx values can be turned into rlfuns through the
 * 'app' and 'rlfunc' functions present in READLINE_APP and READLINE_RESULT
 * structures, respectively, or in READLINE_APP_RESULT structures, which
 * combine both (see readline-type.sig for details).
 *
 * The following READLINE_APP_RESULT structures are predefined:
 * - RLInt (for int)
 * - RLString (for string)
 * - RLBool (for bool)
 * - RLUnit (implicitly applies () and avoids output for the 'unit' type)
 *
 * New READLINE_APP, READLINE_RESULT and READLINE_APP_RESULT structures
 * can be generated through the 'RLMakeApp', 'RLMakeResult' and
 * 'RLMakeAppResult' functors (cf. readline-types.sig).
 *
 * An alternative in some situations is to use the 'RLMakeFiniteTableApp' functor
 * (cf. readline-auxtypes.sig).
 *)

signature READLINE =
sig
    type 'a rlfun_ctx = 'a ReadlineFoundation.rlfun_ctx
    type rlfun = ReadlineFoundation.rlfun

    type menu_item		(* A single menu item *)
    type menu			(* A menu, consisting of a collection of menu items *)

    val rlfun : string * 'a -> 'a rlfun_ctx		(* Builds a new rlfun_ctx from a value name
							 * and the value itself *)

    val apply_const : 'a -> (('a -> 'b) rlfun_ctx)
		      -> 'b rlfun_ctx			(* Applies an rlfun_ctx to a constant argument *)

    val menu_item : rlfun -> menu_item			(* Builds a menu item for an rlfun *)
    val menu : menu_item list -> menu			(* Turns a list of menu items into a menu *)
    val sub_menu : string * menu -> menu_item		(* Generates a submenu from a menu and a submenu name *)



    type prompt = string

    val readline : prompt * menu -> string		(* Reads a single string with readline, using the
							 * specified menu for completion *)
    val process : string * menu -> unit			(* Process the input for the specified menu *)
    val process_readline : prompt * menu -> unit	(* Conceptually 'process o readline' *)
    val read : prompt -> string				(* executes 'readline' without custom completion *)
end
