/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import pm_refactoring.PMProcessor;
import pm_refactoring.PMProject;
import pm_refactoring.PMProjectListener;
import pm_refactoring.PMWorkspace;
import pm_refactoring.steps.PMDelegateStep;

public class PMDelegateProcessor
extends RefactoringProcessor
implements PMProcessor,
PMProjectListener {
    ICompilationUnit _iCompilationUnit;
    ITextSelection _textSelection;
    String _delegateIdentifier;
    PMDelegateStep _step;

    public PMDelegateProcessor(ITextSelection selection, ICompilationUnit iCompilationUnit) {
        this._textSelection = selection;
        this._iCompilationUnit = iCompilationUnit;
    }

    public ICompilationUnit getICompilationUnit() {
        return this._iCompilationUnit;
    }

    public void setDelegateIdentifier(String delegateIdentifier) {
        this._delegateIdentifier = delegateIdentifier;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iCompilationUnit.getJavaProject());
        if (!project.sourcesAreOutOfSync()) {
            ASTNode selectedNode = project.nodeForSelection(this._textSelection, this._iCompilationUnit);
            if (selectedNode instanceof MethodInvocation) {
                return new RefactoringStatus();
            }
            return RefactoringStatus.createFatalErrorStatus((String)("Please select a method invocation [not a " + selectedNode.getClass() + "]"));
        }
        return RefactoringStatus.createWarningStatus((String)"PM Model is out of date. This will reinitialize.");
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iCompilationUnit.getJavaProject());
        project.syncSources();
        NullChange result = new NullChange();
        ASTNode selectedNode = project.nodeForSelection(this._textSelection, this._iCompilationUnit);
        this._step = new PMDelegateStep(project, selectedNode);
        this._step.setDelegateIdentifier(this._delegateIdentifier);
        result = this._step.createCompositeChange("Delegate");
        return result;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return "edu.colorado.plan.PMRDelegateRefactoring";
    }

    public String getProcessorName() {
        return "PMDelegateRefactoring";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public void textChangeWasApplied() {
        this._step.performASTChange();
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iCompilationUnit.getJavaProject());
        project.addProjectListener(this);
    }

    public void textChangeWasNotApplied() {
        this._step.cleanup();
    }

    public void projectDidReparse(PMProject project) {
        this._step.updateAfterReparse();
        this._step.cleanup();
    }
}

