/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.WeakHashMap;
import org.eclipse.jdt.core.dom.ASTNode;
import pm_refactoring.PMNodeReference;

public class PMNodeReferenceStore {
    WeakHashMap<PMNodeReference, WeakReference<ASTNode>> _nodesForReferences = new WeakHashMap();
    WeakHashMap<ASTNode, WeakReference<PMNodeReference>> _referencesForNodes = new WeakHashMap();

    public ASTNode getNodeForReference(PMNodeReference nodeIdentifier) {
        return (ASTNode)this._nodesForReferences.get(nodeIdentifier).get();
    }

    public PMNodeReference getReferenceForNode(ASTNode node) {
        PMNodeReference reference;
        WeakReference<PMNodeReference> weakReference = this._referencesForNodes.get(node);
        if (weakReference == null || weakReference.get() == null) {
            reference = new PMUUIDNodeReference(node);
            this._nodesForReferences.put(reference, new WeakReference<ASTNode>(node));
            this._referencesForNodes.put(node, new WeakReference<PMNodeReference>(reference));
        } else {
            reference = (PMNodeReference)weakReference.get();
        }
        return reference;
    }

    public void replaceOldNodeVersionWithNewVersion(ASTNode oldNode, ASTNode newNode) {
        PMNodeReference reference;
        WeakReference<PMNodeReference> referenceWeakRef = this._referencesForNodes.get(oldNode);
        if (referenceWeakRef != null && (reference = (PMNodeReference)referenceWeakRef.get()) != null) {
            this._referencesForNodes.remove(oldNode);
            this._referencesForNodes.put(newNode, referenceWeakRef);
            this._nodesForReferences.put(reference, new WeakReference<ASTNode>(newNode));
        }
    }

    private static String generatedIdentifierForNode(ASTNode node) {
        return String.valueOf(node.getClass().getName().toString()) + ":" + UUID.randomUUID().toString();
    }

    public class PMUUIDNodeReference
    implements PMNodeReference {
        String _description;

        private PMUUIDNodeReference(ASTNode node) {
            this._description = PMNodeReferenceStore.generatedIdentifierForNode(node);
        }

        public ASTNode getNode() {
            return PMNodeReferenceStore.this.getNodeForReference(this);
        }
    }
}

