/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.ITextSelection;
import pm_refactoring.PMASTMatcher;
import pm_refactoring.PMASTQuery;
import pm_refactoring.PMCompilationUnit;
import pm_refactoring.PMNodeReference;
import pm_refactoring.PMNodeReferenceStore;
import pm_refactoring.PMPasteboard;
import pm_refactoring.PMProjectListener;
import pm_refactoring.PMTimer;
import pm_refactoring.inconsistencies.PMInconsistency;
import pm_refactoring.models.PMNameModel;
import pm_refactoring.models.PMUDModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMProject {
    IJavaProject _iJavaProject;
    Map<String, PMInconsistency> _currentInconsistencies;
    HashMap<String, PMCompilationUnitImplementation> _pmCompilationUnits;
    ArrayList<PMProjectListener> _projectListeners;
    PMUDModel _udModel;
    PMNameModel _nameModel;
    PMPasteboard _pasteboard;
    PMNodeReferenceStore _nodeReferenceStore = new PMNodeReferenceStore();

    protected PMProject(IJavaProject iJavaProject) {
        this._iJavaProject = iJavaProject;
        this._currentInconsistencies = new HashMap<String, PMInconsistency>();
        this._pmCompilationUnits = new HashMap();
        this._projectListeners = new ArrayList();
        this._pasteboard = new PMPasteboard(this);
        this.updateToNewVersionsOfICompilationUnits(true);
    }

    public IJavaProject getIJavaProject() {
        return this._iJavaProject;
    }

    public PMPasteboard getPasteboard() {
        return this._pasteboard;
    }

    public void addProjectListener(PMProjectListener listener) {
        this._projectListeners.add(listener);
    }

    public void removeProjectListener(PMProjectListener listener) {
        this._projectListeners.remove(listener);
    }

    public ArrayList<PMProjectListener> projectListeners() {
        return new ArrayList<PMProjectListener>(this._projectListeners);
    }

    public void syncSources() {
        if (this.sourcesAreOutOfSync()) {
            this.updateToNewVersionsOfICompilationUnits(true);
        }
    }

    public boolean sourcesAreOutOfSync() {
        for (ICompilationUnit iCompilationUnit : this.getSourceFilesForProject(this._iJavaProject)) {
            if (this.sourceIsUpToDateForICompilationUnit(iCompilationUnit)) continue;
            return true;
        }
        return false;
    }

    public boolean sourceIsUpToDateForICompilationUnit(ICompilationUnit iCompilationUnit) {
        PMCompilationUnitImplementation pmCompilationUnit = (PMCompilationUnitImplementation)this.getPMCompilationUnitForICompilationUnit(iCompilationUnit);
        return pmCompilationUnit.textHasChanged();
    }

    public void justParseMeasurement(boolean resolveBindings) {
        Set<ICompilationUnit> iCompilationUnits = this.getSourceFilesForProject(this._iJavaProject);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(this._iJavaProject);
        parser.setResolveBindings(resolveBindings);
        parser.createASTs(iCompilationUnits.toArray(new ICompilationUnit[iCompilationUnits.size()]), new String[0], new ASTRequestor(){

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            }
        }, null);
    }

    public void updateToNewVersionsOfICompilationUnits() {
        this.updateToNewVersionsOfICompilationUnits(false);
    }

    public void updateToNewVersionsOfICompilationUnits(boolean firstTime) {
        Set<ICompilationUnit> iCompilationUnits = this.getSourceFilesForProject(this._iJavaProject);
        Set<ICompilationUnit> previouslyKnownCompilationUnits = this.allKnownICompilationUnits();
        if (!firstTime && !iCompilationUnits.equals(previouslyKnownCompilationUnits)) {
            System.err.println("Previously known ICompilationUnits does not match current ICompilationUnits so resetting!!!");
            this._pmCompilationUnits.clear();
            firstTime = true;
        }
        final boolean finalFirstTime = firstTime;
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(this._iJavaProject);
        parser.setResolveBindings(true);
        ASTRequestor requestor = new ASTRequestor(){

            public void acceptAST(ICompilationUnit source, CompilationUnit newCompilationUnit) {
                PMTimer.sharedTimer().start("PARSE_INTERNAL");
                PMCompilationUnitImplementation pmCompilationUnit = PMProject.this._pmCompilationUnits.get(source.getHandleIdentifier());
                if (pmCompilationUnit == null) {
                    pmCompilationUnit = new PMCompilationUnitImplementation(source, newCompilationUnit);
                    PMProject.this._pmCompilationUnits.put(source.getHandleIdentifier(), pmCompilationUnit);
                }
                if (!finalFirstTime) {
                    CompilationUnit oldCompilationUnit = PMProject.this.parsedCompilationUnitForICompilationUnit(source);
                    if (PMProject.this.recursivelyReplaceNodeWithCopy((ASTNode)oldCompilationUnit, (ASTNode)newCompilationUnit)) {
                        pmCompilationUnit.updatePair(source, newCompilationUnit);
                    } else {
                        System.err.println("Couldn't update to new version of compilation unit!");
                        System.err.println("Old compilation unit: " + oldCompilationUnit);
                        System.err.println("New compilation unit: " + newCompilationUnit);
                        PMProject.this.resetModel();
                    }
                }
                PMTimer.sharedTimer().stop("PARSE_INTERNAL");
            }
        };
        parser.createASTs(iCompilationUnits.toArray(new ICompilationUnit[iCompilationUnits.size()]), new String[0], requestor, null);
        if (finalFirstTime) {
            this.resetModel();
        }
        for (PMProjectListener listener : this.projectListeners()) {
            listener.projectDidReparse(this);
        }
        this._currentInconsistencies.clear();
    }

    private void resetModel() {
        this._udModel = new PMUDModel(this);
        this._nameModel = new PMNameModel(this);
    }

    private Set<ICompilationUnit> getSourceFilesForProject(IJavaProject iJavaProject) {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        try {
            IPackageFragment[] iPackageFragmentArray = iJavaProject.getPackageFragments();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment packageFragment = iPackageFragmentArray[n2];
                if (packageFragment.getKind() == 1 && packageFragment.containsJavaResources()) {
                    ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
                    int n3 = iCompilationUnitArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICompilationUnit iCompilationUnit = iCompilationUnitArray[n4];
                        result.add(iCompilationUnit);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Set<ICompilationUnit> getICompilationUnits() {
        return this.getSourceFilesForProject(this._iJavaProject);
    }

    public ASTNode nodeForSelection(ITextSelection selection, ICompilationUnit iCompilationUnit) {
        CompilationUnit compilationUnit = (CompilationUnit)this.findASTRootForICompilationUnit(iCompilationUnit);
        ASTNode selectedNode = PMASTQuery.nodeForSelectionInCompilationUnit(selection.getOffset(), selection.getLength(), compilationUnit);
        return selectedNode;
    }

    public Set<SimpleName> relatedNodesForSimpleName(SimpleName simpleName) {
        HashSet<SimpleName> result = new HashSet<SimpleName>();
        result.addAll(this._nameModel.nameNodesRelatedToNameNode(simpleName));
        return result;
    }

    public Set<PMCompilationUnit> getPMCompilationUnits() {
        HashSet<PMCompilationUnit> result = new HashSet<PMCompilationUnit>();
        result.addAll(this._pmCompilationUnits.values());
        return result;
    }

    private Set<ICompilationUnit> allKnownICompilationUnits() {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        for (PMCompilationUnit pmCompilationUnit : this.getPMCompilationUnits()) {
            result.add(pmCompilationUnit.getICompilationUnit());
        }
        return result;
    }

    public SimpleName simpleNameForDeclaringNode(ASTNode declaringNode) {
        if (declaringNode != null) {
            if (declaringNode instanceof VariableDeclarationFragment) {
                return ((VariableDeclarationFragment)declaringNode).getName();
            }
            if (declaringNode instanceof SingleVariableDeclaration) {
                return ((SingleVariableDeclaration)declaringNode).getName();
            }
            if (declaringNode instanceof VariableDeclarationFragment) {
                return ((VariableDeclarationFragment)declaringNode).getName();
            }
            if (declaringNode instanceof TypeDeclaration) {
                return ((TypeDeclaration)declaringNode).getName();
            }
            if (declaringNode instanceof MethodDeclaration) {
                return ((MethodDeclaration)declaringNode).getName();
            }
            if (declaringNode instanceof TypeParameter) {
                return ((TypeParameter)declaringNode).getName();
            }
            throw new RuntimeException("Unexpected declaring ASTNode type " + declaringNode + " of class " + declaringNode.getClass());
        }
        throw new RuntimeException("Tried to find simple name for null declaring node!");
    }

    public ASTNode findDeclaringNodeForName(Name nameNode) {
        ICompilationUnit declaringICompilationUnit;
        IJavaElement elementForBinding;
        CompilationUnit usingCompilationUnit = (CompilationUnit)nameNode.getRoot();
        IBinding nameBinding = nameNode.resolveBinding();
        if (nameBinding != null && (elementForBinding = nameBinding.getJavaElement()) != null && (declaringICompilationUnit = (ICompilationUnit)elementForBinding.getAncestor(5)) != null) {
            PMCompilationUnit declaringPMCompilationUnit = this.getPMCompilationUnitForICompilationUnit(declaringICompilationUnit);
            CompilationUnit declaringCompilationUnit = declaringPMCompilationUnit.getASTNode();
            ASTNode declaringNode = declaringCompilationUnit.findDeclaringNode(nameBinding);
            if (declaringNode == null) {
                declaringNode = usingCompilationUnit.findDeclaringNode(nameNode.resolveBinding().getKey());
            }
            return declaringNode;
        }
        return null;
    }

    public boolean nameNodeIsDeclaring(SimpleName name) {
        return this.simpleNameForDeclaringNode(this.findDeclaringNodeForName((Name)name)) == name;
    }

    public ASTNode declaringNodeForTypeName(String fullyQualifiedTypeName) {
        ASTNode declaringNode = null;
        try {
            ICompilationUnit declaringIComputationUnit;
            CompilationUnit declaringCompilationUnit;
            IType type = this._iJavaProject.findType(fullyQualifiedTypeName);
            if (type != null && (declaringCompilationUnit = this.parsedCompilationUnitForICompilationUnit(declaringIComputationUnit = (ICompilationUnit)type.getAncestor(5))) != null) {
                declaringNode = declaringCompilationUnit.findDeclaringNode(type.getKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return declaringNode;
    }

    public PMCompilationUnit findPMCompilationUnitForNode(ASTNode node) {
        return this._pmCompilationUnits.get(((ICompilationUnit)((CompilationUnit)node.getRoot()).getJavaElement()).getHandleIdentifier());
    }

    public PMCompilationUnit getPMCompilationUnitForICompilationUnit(ICompilationUnit iCompilationUnit) {
        return this._pmCompilationUnits.get(iCompilationUnit.getHandleIdentifier());
    }

    public boolean recursivelyReplaceNodeWithCopy(ASTNode node, ASTNode copy) {
        PMTimer.sharedTimer().start("NODE_REPLACEMENT");
        PMASTMatcher astMatcher = new PMASTMatcher(node, copy);
        boolean matches = astMatcher.match();
        if (matches) {
            Map<ASTNode, ASTNode> isomorphicNodes = astMatcher.isomorphicNodes();
            for (ASTNode oldNode : isomorphicNodes.keySet()) {
                ASTNode newNode = isomorphicNodes.get(oldNode);
                if (oldNode instanceof SimpleName) {
                    this._nameModel.replaceNameWithName((Name)((SimpleName)oldNode), (Name)((SimpleName)newNode));
                }
                this.replaceNodeWithNode(oldNode, newNode);
            }
        } else {
            System.err.println("Copy [" + copy + "] does not structurally match original [" + node + "]");
            throw new RuntimeException("Copy not does structurally match original");
        }
        PMTimer.sharedTimer().stop("NODE_REPLACEMENT");
        return matches;
    }

    public CompilationUnit parsedCompilationUnitForICompilationUnit(ICompilationUnit iCompilationUnit) {
        return this._pmCompilationUnits.get(iCompilationUnit.getHandleIdentifier()).getASTNode();
    }

    public PMNodeReference getReferenceForNode(ASTNode node) {
        return this._nodeReferenceStore.getReferenceForNode(node);
    }

    public void replaceNodeWithNode(ASTNode oldNode, ASTNode newNode) {
        this._nodeReferenceStore.replaceOldNodeVersionWithNewVersion(oldNode, newNode);
    }

    public Collection<ASTNode> getASTRoots() {
        HashSet<ASTNode> roots = new HashSet<ASTNode>();
        for (PMCompilationUnit pMCompilationUnit : this._pmCompilationUnits.values()) {
            roots.add((ASTNode)pMCompilationUnit.getASTNode());
        }
        return roots;
    }

    public ASTNode findASTRootForICompilationUnit(ICompilationUnit iCompilationUnit) {
        return this.parsedCompilationUnitForICompilationUnit(iCompilationUnit);
    }

    public PMUDModel getUDModel() {
        return this._udModel;
    }

    public PMNameModel getNameModel() {
        return this._nameModel;
    }

    public Set<PMInconsistency> allInconsistencies() {
        HashSet<PMInconsistency> result = new HashSet<PMInconsistency>();
        result.addAll(this._currentInconsistencies.values());
        return result;
    }

    public void rescanForInconsistencies() {
        try {
            this._currentInconsistencies.clear();
            PMTimer.sharedTimer().start("INCONSISTENCIES");
            HashSet<PMInconsistency> inconsistencySet = new HashSet<PMInconsistency>();
            inconsistencySet.addAll(this._nameModel.calculateInconsistencies());
            inconsistencySet.addAll(this._udModel.calculateInconsistencies());
            PMTimer.sharedTimer().stop("INCONSISTENCIES");
            for (ICompilationUnit iCompilationUnit : this.getICompilationUnits()) {
                iCompilationUnit.getResource().deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            }
            for (PMInconsistency inconsistency : inconsistencySet) {
                IResource resource = this.findPMCompilationUnitForNode(inconsistency.getNode()).getICompilationUnit().getResource();
                IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("pm-inconsistency-id", (Object)inconsistency.getID());
                marker.setAttribute("pm-project-id", (Object)this._iJavaProject.getHandleIdentifier());
                marker.setAttribute("pm-accepts-behavioral-change", inconsistency.allowsAcceptBehavioralChange());
                marker.setAttribute("message", (Object)inconsistency.getHumanReadableDescription());
                marker.setAttribute("transient", true);
                ASTNode node = inconsistency.getNode();
                marker.setAttribute("charStart", node.getStartPosition());
                marker.setAttribute("charEnd", node.getStartPosition() + node.getLength());
                this._currentInconsistencies.put(inconsistency.getID(), inconsistency);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public PMInconsistency getInconsistencyWithKey(String key) {
        return this._currentInconsistencies.get(key);
    }

    private class PMCompilationUnitImplementation
    implements PMCompilationUnit {
        ICompilationUnit _iCompilationUnit;
        byte[] _sourceDigest;
        CompilationUnit _compilationUnit;

        public PMCompilationUnitImplementation(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit) {
            this.updatePair(iCompilationUnit, compilationUnit);
        }

        public String getSource() {
            try {
                return this._iCompilationUnit.getSource();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public CompilationUnit getASTNode() {
            return this._compilationUnit;
        }

        public ICompilationUnit getICompilationUnit() {
            return this._iCompilationUnit;
        }

        protected void updatePair(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit) {
            this._compilationUnit = compilationUnit;
            this._iCompilationUnit = iCompilationUnit;
            this.updateSourceDigestForSource(this.getSource());
        }

        private byte[] calculatedHashForSource(String source) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA");
                digest.update(source.getBytes());
                return digest.digest();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private void updateSourceDigestForSource(String source) {
            this._sourceDigest = this.calculatedHashForSource(source);
        }

        public void rename(String newName) {
            try {
                ICompilationUnit newICompilationUnit;
                IPackageFragment parentPackageFragment = (IPackageFragment)this._iCompilationUnit.getParent();
                PMProject.this._pmCompilationUnits.remove(this._iCompilationUnit.getHandleIdentifier());
                this._iCompilationUnit.rename(String.valueOf(newName) + ".java", false, null);
                this._iCompilationUnit = newICompilationUnit = parentPackageFragment.getCompilationUnit(String.valueOf(newName) + ".java");
                PMProject.this._pmCompilationUnits.put(newICompilationUnit.getHandleIdentifier(), this);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public boolean textHasChanged() {
            return Arrays.equals(this.calculatedHashForSource(this.getSource()), this._sourceDigest);
        }
    }
}

