/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import pm_refactoring.PMProcessor;
import pm_refactoring.PMProject;
import pm_refactoring.PMTimer;
import pm_refactoring.PMWorkspace;
import pm_refactoring.steps.PMRenameStep;

public class PMRenameProcessor
extends RenameProcessor
implements PMProcessor {
    ICompilationUnit _iCompilationUnit;
    ITextSelection _textSelection;
    PMRenameStep _renameStep;
    String _newName;
    HashMap<SimpleName, String> _newIdentifersForSimpleNames;

    public PMRenameProcessor(ITextSelection selection, ICompilationUnit iCompilationUnit) {
        this._textSelection = selection;
        this._iCompilationUnit = iCompilationUnit;
        this._newIdentifersForSimpleNames = new HashMap();
    }

    public String getNewName() {
        return this._newName;
    }

    public void setNewName(String newName) {
        this._newName = newName;
    }

    public ICompilationUnit getICompilationUnit() {
        return this._iCompilationUnit;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ASTNode selectedNode;
        PMTimer.sharedTimer().start("STEP");
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iCompilationUnit.getJavaProject());
        RefactoringStatus result = null;
        result = !project.sourcesAreOutOfSync() ? ((selectedNode = project.nodeForSelection(this._textSelection, this._iCompilationUnit)) instanceof SimpleName ? new RefactoringStatus() : RefactoringStatus.createFatalErrorStatus((String)"Please select a name to use the Rename refactoring.")) : RefactoringStatus.createWarningStatus((String)"PM Model is out of date. This will reinitialize.");
        PMTimer.sharedTimer().stop("STEP");
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        PMTimer.sharedTimer().start("STEP");
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iCompilationUnit.getJavaProject());
        project.syncSources();
        this._renameStep = new PMRenameStep(project, (SimpleName)project.nodeForSelection(this._textSelection, this._iCompilationUnit));
        this._renameStep.setNewName(this._newName);
        Change result = this._renameStep.createCompositeChange("Rename");
        PMTimer.sharedTimer().stop("STEP");
        return result;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return "edu.colorado.plan.PMRenameRefactoring";
    }

    public String getProcessorName() {
        return "PMRenameRefactoring";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public void textChangeWasApplied() {
        PMTimer.sharedTimer().start("STEP");
        this._renameStep.performASTChange();
        PMTimer.sharedTimer().stop("STEP");
    }

    public void textChangeWasNotApplied() {
    }
}

