/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import pm_refactoring.PMASTNodeUtils;
import pm_refactoring.PMProcessor;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.steps.PMSplitStep;

public class PMSplitProcessor
extends RefactoringProcessor
implements PMProcessor {
    ICompilationUnit _iCompilationUnit;
    ITextSelection _textSelection;
    PMSplitStep _step;

    public PMSplitProcessor(ITextSelection selection, ICompilationUnit iCompilationUnit) {
        this._textSelection = selection;
        this._iCompilationUnit = iCompilationUnit;
    }

    public ICompilationUnit getICompilationUnit() {
        return this._iCompilationUnit;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iCompilationUnit.getJavaProject());
        if (!project.sourcesAreOutOfSync()) {
            SimpleName name;
            VariableDeclaration declaration;
            Assignment assignmentExpression;
            ExpressionStatement assignmentStatement;
            Assignment assignment;
            project.syncSources();
            ASTNode selectedNode = project.nodeForSelection(this._textSelection, this._iCompilationUnit);
            if (selectedNode instanceof Assignment && (assignment = (Assignment)selectedNode).getParent() instanceof ExpressionStatement) {
                selectedNode = assignment.getParent();
            }
            if (selectedNode instanceof ExpressionStatement && (assignmentStatement = (ExpressionStatement)selectedNode).getExpression() instanceof Assignment && (assignmentExpression = (Assignment)assignmentStatement.getExpression()).getLeftHandSide() instanceof SimpleName && (declaration = PMASTNodeUtils.localVariableDeclarationForSimpleName(name = (SimpleName)assignmentExpression.getLeftHandSide())) != null && PMASTNodeUtils.variableDeclarationIsLocal(declaration)) {
                this._step = new PMSplitStep(project, (ExpressionStatement)selectedNode);
                return new RefactoringStatus();
            }
            return RefactoringStatus.createFatalErrorStatus((String)"Split temporary can only be run on an assignment to a local variable.");
        }
        return RefactoringStatus.createWarningStatus((String)"PM Model is out of date. This will reinitialize.");
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        NullChange result = new NullChange();
        result = this._step.createCompositeChange("Split");
        return result;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return "edu.colorado.plan.PMSplitTemporaryRefactoring";
    }

    public String getProcessorName() {
        return "PMSplitProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public void textChangeWasApplied() {
        this._step.performASTChange();
    }

    public void textChangeWasNotApplied() {
        this._step.cleanup();
    }
}

