/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import java.util.HashMap;

public class PMTimer {
    protected HashMap<String, Long> _accumulatedMilliseconds = new HashMap();
    protected HashMap<String, Long> _startTimes = new HashMap();
    protected static PMTimer _sharedTimer;

    public static PMTimer sharedTimer() {
        if (_sharedTimer == null) {
            _sharedTimer = new PMTimer();
        }
        return _sharedTimer;
    }

    public void start(String key) {
        this._startTimes.put(key, System.currentTimeMillis());
        if (!this._accumulatedMilliseconds.containsKey(key)) {
            this._accumulatedMilliseconds.put(key, 0L);
        }
    }

    public void stop(String key) {
        long stopTime = System.currentTimeMillis();
        long startTime = this._startTimes.get(key);
        long accumulatedTime = this._accumulatedMilliseconds.get(key);
        this._accumulatedMilliseconds.put(key, accumulatedTime += stopTime - startTime);
    }

    public void clear(String key) {
        this._accumulatedMilliseconds.remove(key);
        this._startTimes.remove(key);
    }

    public double accumulatedSecondsForKey(String key) {
        if (this._accumulatedMilliseconds.containsKey(key)) {
            return (double)this._accumulatedMilliseconds.get(key).longValue() / 1000.0;
        }
        System.err.println("ERROR: no accumulated time for key: " + key);
        return 0.0;
    }
}

