/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import java.util.HashMap;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import pm_refactoring.PMProject;

public class PMWorkspace {
    private static PMWorkspace _sharedWorkspace = null;
    private HashMap<IJavaProject, PMProject> _projectMapping = new HashMap();

    public static synchronized PMWorkspace sharedWorkspace() {
        if (_sharedWorkspace == null) {
            _sharedWorkspace = new PMWorkspace();
        }
        return _sharedWorkspace;
    }

    private PMWorkspace() {
    }

    public synchronized PMProject projectForIJavaProject(IJavaProject iJavaProject) {
        PMProject result = this._projectMapping.get(iJavaProject);
        if (result == null) {
            result = new PMProject(iJavaProject);
            this._projectMapping.put(iJavaProject, result);
        }
        return result;
    }

    public synchronized void removeProjectForIJavaProject(IJavaProject iJavaProject) {
        this._projectMapping.remove(iJavaProject);
    }

    public static void applyRewrite(ASTRewrite rewrite, ICompilationUnit iCompilationUnit) {
        try {
            TextEdit astEdit = rewrite.rewriteAST();
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = iCompilationUnit.getPath();
            try {
                bufferManager.connect(path, LocationKind.IFILE, null);
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                IDocument document = textFileBuffer.getDocument();
                astEdit.apply(document);
                textFileBuffer.commit(null, false);
            }
            finally {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

