/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import pm_refactoring.analysis.PMBlock;
import pm_refactoring.analysis.PMDef;
import pm_refactoring.analysis.PMUse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMRDefsAnalysis {
    protected MethodDeclaration _methodDeclaration;
    protected ArrayList<PMDef> _definitions;
    protected Map<IBinding, Set<PMDef>> _definitionsByBinding;
    protected Map<ASTNode, PMDef> _definitionsByDefiningNode;
    protected Map<SimpleName, PMUse> _usesByName;
    protected ArrayList<PMBlock> _allBlocks;
    protected Map<ASTNode, PMBlock> _blocksByNode;
    protected ArrayList<VariableDeclaration> _declarations;
    protected Map<PMBlock, Set<VariableAssignment>> _reachingDefsOnEntry;
    protected Map<PMBlock, Set<VariableAssignment>> _reachingDefsOnExit;
    HashMap<PMDef, HashMap<IBinding, VariableAssignment>> _uniqueVariableAssigments = new HashMap();

    public PMRDefsAnalysis(MethodDeclaration methodDeclaration) {
        this._methodDeclaration = methodDeclaration;
        this.runAnalysis();
    }

    public static List<ASTNode> findDefiningNodesUnderNode(ASTNode rootNode) {
        final ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        ASTVisitor visitor = new ASTVisitor(){

            boolean isAnalyzableLeftHandSide(ASTNode lhs) {
                return lhs instanceof SimpleName;
            }

            public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
                result.add(singleVariableDeclaration);
                return true;
            }

            public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
                result.add(variableDeclarationFragment);
                return true;
            }

            public boolean visit(Assignment assignment) {
                if (this.isAnalyzableLeftHandSide((ASTNode)assignment.getLeftHandSide())) {
                    result.add(assignment);
                }
                return true;
            }

            public boolean visit(PrefixExpression prefixExpression) {
                if ((prefixExpression.getOperator() == PrefixExpression.Operator.INCREMENT || prefixExpression.getOperator() == PrefixExpression.Operator.DECREMENT) && this.isAnalyzableLeftHandSide((ASTNode)prefixExpression.getOperand())) {
                    result.add(prefixExpression);
                }
                return true;
            }

            public boolean visit(PostfixExpression postfixExpression) {
                if (this.isAnalyzableLeftHandSide((ASTNode)postfixExpression.getOperand())) {
                    result.add(postfixExpression);
                }
                return true;
            }
        };
        rootNode.accept(visitor);
        return result;
    }

    private void addDefinitionForNode(ASTNode node) {
        PMDef definition = new PMDef(node);
        this._definitions.add(definition);
        this._definitionsByDefiningNode.put(node, definition);
    }

    boolean isAnalyzableLeftHandSide(ASTNode lhs) {
        return lhs instanceof SimpleName;
    }

    void findDefinitions() {
        this._definitions = new ArrayList();
        this._definitionsByDefiningNode = new HashMap<ASTNode, PMDef>();
        List<ASTNode> definingNodes = PMRDefsAnalysis.findDefiningNodesUnderNode((ASTNode)this._methodDeclaration.getBody());
        for (ASTNode definingNode : definingNodes) {
            this.addDefinitionForNode(definingNode);
        }
        this._definitionsByBinding = new HashMap<IBinding, Set<PMDef>>();
        for (PMDef def : this._definitions) {
            IBinding binding = def.getBinding();
            Set<PMDef> definitionsForBinding = this._definitionsByBinding.get(binding);
            if (definitionsForBinding == null) {
                definitionsForBinding = new HashSet<PMDef>();
                this._definitionsByBinding.put(binding, definitionsForBinding);
            }
            definitionsForBinding.add(def);
        }
    }

    public ArrayList<PMDef> getDefinitions() {
        return this._definitions;
    }

    public PMDef getDefinitionForDefiningNode(ASTNode definingNode) {
        return this._definitionsByDefiningNode.get(definingNode);
    }

    public Collection<PMUse> getUses() {
        return this._usesByName.values();
    }

    public PMUse useForSimpleName(SimpleName name) {
        return this._usesByName.get(name);
    }

    protected boolean astNodeContainsDefinition(ASTNode node) {
        final boolean[] containsDefinition = new boolean[]{false};
        node.accept(new ASTVisitor(){

            public boolean visit(Assignment assignment) {
                containsDefinition[0] = true;
                return true;
            }

            public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
                containsDefinition[0] = true;
                return true;
            }

            public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
                containsDefinition[0] = true;
                return true;
            }
        });
        return containsDefinition[0];
    }

    protected void addSerialBlockToEndOfList(PMBlock block, ArrayList<PMBlock> blockList) {
        if (blockList.size() > 0) {
            PMBlock lastBlock = blockList.get(blockList.size() - 1);
            lastBlock.addOutgoingBlock(block);
        }
        blockList.add(block);
    }

    protected void mergeBlockLists(ArrayList<PMBlock> first, ArrayList<PMBlock> second) {
        if (first.size() > 0) {
            first.get(first.size() - 1).addOutgoingBlock(second.get(0));
        }
        first.addAll(second);
    }

    protected ArrayList<PMBlock> generateBlocksForExpression(Expression expression) {
        ArrayList<PMBlock> result = new ArrayList<PMBlock>();
        if (expression instanceof Assignment) {
            Assignment assignmentExpression = (Assignment)expression;
            PMBlock block = new PMBlock();
            this.mergeBlockLists(result, this.generateBlocksForExpression(assignmentExpression.getRightHandSide()));
            block.addNode((ASTNode)expression);
            this.addSerialBlockToEndOfList(block, result);
        } else if (expression instanceof VariableDeclarationExpression) {
            VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)expression;
            for (VariableDeclarationFragment fragment : variableDeclarationExpression.fragments()) {
                PMBlock block = new PMBlock();
                block.addNode((ASTNode)fragment);
                this.addSerialBlockToEndOfList(block, result);
            }
        } else {
            PMBlock block = new PMBlock();
            block.addNode((ASTNode)expression);
            this.addSerialBlockToEndOfList(block, result);
        }
        return result;
    }

    protected ArrayList<PMBlock> generateBlocksForStatement(Statement statement) {
        ArrayList<PMBlock> result = new ArrayList<PMBlock>();
        if (statement instanceof ExpressionStatement) {
            ExpressionStatement expressionStatement = (ExpressionStatement)statement;
            result.addAll(this.generateBlocksForExpression(expressionStatement.getExpression()));
        } else if (statement instanceof Block) {
            Block blockStatement = (Block)statement;
            for (Statement subStatement : blockStatement.statements()) {
                ArrayList<PMBlock> blocksForSubStatement = this.generateBlocksForStatement(subStatement);
                this.mergeBlockLists(result, blocksForSubStatement);
            }
        } else if (statement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)statement;
            ArrayList<PMBlock> blocksForGuard = this.generateBlocksForExpression(ifStatement.getExpression());
            PMBlock endingGuardBlock = blocksForGuard.get(blocksForGuard.size() - 1);
            PMBlock exitBlock = new PMBlock();
            this.mergeBlockLists(result, blocksForGuard);
            ArrayList<PMBlock> blocksForThen = this.generateBlocksForStatement(ifStatement.getThenStatement());
            this.mergeBlockLists(result, blocksForThen);
            PMBlock endingThenBlock = blocksForThen.get(blocksForThen.size() - 1);
            endingThenBlock.addOutgoingBlock(exitBlock);
            if (ifStatement.getElseStatement() != null) {
                ArrayList<PMBlock> blocksForElse = this.generateBlocksForStatement(ifStatement.getElseStatement());
                PMBlock startingElseBlock = blocksForElse.get(0);
                endingGuardBlock.addOutgoingBlock(startingElseBlock);
                PMBlock endingElseBlock = blocksForElse.get(blocksForElse.size() - 1);
                endingElseBlock.addOutgoingBlock(exitBlock);
                result.addAll(blocksForElse);
            } else {
                endingGuardBlock.addOutgoingBlock(exitBlock);
            }
            result.add(exitBlock);
        } else if (statement instanceof WhileStatement) {
            WhileStatement whileStatement = (WhileStatement)statement;
            ArrayList<PMBlock> blocksForGuard = this.generateBlocksForExpression(whileStatement.getExpression());
            PMBlock startingGuardBlock = blocksForGuard.get(0);
            PMBlock lastGuardBlock = blocksForGuard.get(blocksForGuard.size() - 1);
            PMBlock exitBlock = new PMBlock();
            this.mergeBlockLists(result, blocksForGuard);
            ArrayList<PMBlock> blocksForBody = this.generateBlocksForStatement(whileStatement.getBody());
            this.mergeBlockLists(result, blocksForBody);
            PMBlock lastBodyBlock = blocksForBody.get(blocksForBody.size() - 1);
            lastBodyBlock.addOutgoingBlock(startingGuardBlock);
            lastGuardBlock.addOutgoingBlock(exitBlock);
            result.add(exitBlock);
        }
        PMBlock statementBlock = new PMBlock();
        statementBlock.addNode((ASTNode)statement);
        this.addSerialBlockToEndOfList(statementBlock, result);
        return result;
    }

    void findAllBlocks() {
        this._allBlocks = new ArrayList();
        this._allBlocks.add(new PMBlock());
        this.mergeBlockLists(this._allBlocks, this.generateBlocksForStatement((Statement)this._methodDeclaration.getBody()));
        this._blocksByNode = new HashMap<ASTNode, PMBlock>();
        for (PMBlock block : this._allBlocks) {
            for (ASTNode node : block.getNodes()) {
                this._blocksByNode.put(node, block);
            }
        }
    }

    public ArrayList<PMBlock> getAllBlocks() {
        return this._allBlocks;
    }

    protected PMBlock getBlockForNode(ASTNode node) {
        ASTNode originalNode = node;
        do {
            PMBlock block;
            if ((block = this._blocksByNode.get(node)) != null) {
                return block;
            }
            node = node.getParent();
        } while (node != null);
        throw new RuntimeException("Couldn't find block for definingnode  " + originalNode);
    }

    HashMap<PMBlock, HashSet<VariableAssignment>> findGenSets() {
        HashMap<PMBlock, HashSet<VariableAssignment>> result = new HashMap<PMBlock, HashSet<VariableAssignment>>();
        for (PMDef definition : this._definitions) {
            HashSet<VariableAssignment> genSet = new HashSet<VariableAssignment>();
            IBinding binding = definition.getBinding();
            if (binding == null) continue;
            genSet.add(this.uniqueVariableAssignment(definition, binding));
            PMBlock block = this.getBlockForNode(definition.getDefiningNode());
            result.put(block, genSet);
        }
        return result;
    }

    HashMap<PMBlock, HashSet<VariableAssignment>> findKillSets() {
        HashMap<PMBlock, HashSet<VariableAssignment>> result = new HashMap<PMBlock, HashSet<VariableAssignment>>();
        for (PMDef definition : this._definitions) {
            IBinding binding = definition.getBinding();
            if (binding == null) continue;
            HashSet<VariableAssignment> killSet = new HashSet<VariableAssignment>();
            killSet.add(this.uniqueVariableAssignment(null, binding));
            for (PMDef otherDefinition : this._definitionsByBinding.get(binding)) {
                if (otherDefinition == definition) continue;
                killSet.add(this.uniqueVariableAssignment(otherDefinition, binding));
            }
            PMBlock block = this.getBlockForNode(definition.getDefiningNode());
            result.put(block, killSet);
        }
        return result;
    }

    protected boolean simpleNameIsUse(SimpleName name) {
        ASTNode parent = name.getParent();
        if (parent instanceof Assignment && ((Assignment)parent).getLeftHandSide() == name) {
            return false;
        }
        return !(parent instanceof VariableDeclaration) || ((VariableDeclaration)parent).getName() != name;
    }

    protected void findUses() {
        this._usesByName = new HashMap<SimpleName, PMUse>();
        Block body = this._methodDeclaration.getBody();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(SimpleName name) {
                PMBlock block = PMRDefsAnalysis.this.getBlockForNode((ASTNode)name);
                Set<VariableAssignment> reachingDefinitions = PMRDefsAnalysis.this._reachingDefsOnEntry.get(block);
                if (PMRDefsAnalysis.this.simpleNameIsUse(name)) {
                    PMUse use = new PMUse(name);
                    PMRDefsAnalysis.this._usesByName.put(name, use);
                    IBinding variableBinding = name.resolveBinding();
                    for (VariableAssignment reachingDefinition : reachingDefinitions) {
                        if (reachingDefinition.getVariableBinding() != variableBinding) continue;
                        use.addReachingDefinition(reachingDefinition.getDefinition());
                    }
                }
                return true;
            }
        };
        body.accept(visitor);
    }

    void runAnalysis() {
        this.findDefinitions();
        this.findAllBlocks();
        HashMap<PMBlock, HashSet<VariableAssignment>> genSets = this.findGenSets();
        HashMap<PMBlock, HashSet<VariableAssignment>> killSets = this.findKillSets();
        this._reachingDefsOnEntry = new HashMap<PMBlock, Set<VariableAssignment>>();
        this._reachingDefsOnExit = new HashMap<PMBlock, Set<VariableAssignment>>();
        PMBlock initialBlock = this._allBlocks.get(0);
        for (final PMBlock block : this._allBlocks) {
            this._reachingDefsOnEntry.put(block, new HashSet());
            if (block == initialBlock) {
                this._methodDeclaration.accept(new ASTVisitor(){

                    public boolean visit(SimpleName name) {
                        IBinding binding = name.resolveBinding();
                        if (binding instanceof IVariableBinding) {
                            PMRDefsAnalysis.this._reachingDefsOnEntry.get(block).add(PMRDefsAnalysis.this.uniqueVariableAssignment(null, binding));
                        }
                        return true;
                    }
                });
            }
            this._reachingDefsOnExit.put(block, new HashSet());
        }
        boolean changed = false;
        do {
            changed = false;
            for (PMBlock block : this._allBlocks) {
                HashSet<VariableAssignment> genSet;
                if (block != initialBlock) {
                    HashSet newEntryReachingDefs = new HashSet();
                    for (PMBlock incomingBlock : block.getIncomingBlocks()) {
                        if (this._reachingDefsOnExit.get(incomingBlock) == null) {
                            System.out.println("Coulding find reaching defs for block " + incomingBlock);
                        }
                        newEntryReachingDefs.addAll(this._reachingDefsOnExit.get(incomingBlock));
                    }
                    if (!newEntryReachingDefs.equals(this._reachingDefsOnEntry.get(block))) {
                        changed = true;
                        this._reachingDefsOnEntry.put(block, newEntryReachingDefs);
                    }
                }
                HashSet<VariableAssignment> newExitReachingDefs = new HashSet<VariableAssignment>();
                newExitReachingDefs.addAll((Collection)this._reachingDefsOnEntry.get(block));
                HashSet<VariableAssignment> killSet = killSets.get(block);
                if (killSet != null) {
                    newExitReachingDefs.removeAll(killSet);
                }
                if ((genSet = genSets.get(block)) != null) {
                    newExitReachingDefs.addAll(genSet);
                }
                if (newExitReachingDefs.equals(this._reachingDefsOnExit.get(block))) continue;
                changed = true;
                this._reachingDefsOnExit.put(block, newExitReachingDefs);
            }
        } while (changed);
        this.findUses();
    }

    VariableAssignment uniqueVariableAssignment(PMDef definition, IBinding variableBinding) {
        VariableAssignment variableAssignment;
        if (variableBinding == null) {
            throw new RuntimeException("variableBinding for " + definition + " is null!");
        }
        HashMap<Object, VariableAssignment> assignmentsForLocation = this._uniqueVariableAssigments.get(definition);
        if (assignmentsForLocation == null) {
            assignmentsForLocation = new HashMap();
            this._uniqueVariableAssigments.put(definition, assignmentsForLocation);
        }
        if ((variableAssignment = assignmentsForLocation.get(variableBinding)) == null) {
            variableAssignment = new VariableAssignment(definition, variableBinding);
            assignmentsForLocation.put(variableBinding, variableAssignment);
        }
        return variableAssignment;
    }

    protected static class VariableAssignment {
        protected PMDef _definition;
        protected IBinding _variableBinding;

        public VariableAssignment(PMDef definition, IBinding variableBinding) {
            this._definition = definition;
            this._variableBinding = variableBinding;
        }

        public PMDef getDefinition() {
            return this._definition;
        }

        public IBinding getVariableBinding() {
            return this._variableBinding;
        }
    }
}

