/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import pm_refactoring.PMCompilationUnit;
import pm_refactoring.PMProject;
import pm_refactoring.inconsistencies.PMInconsistency;
import pm_refactoring.inconsistencies.PMNameCapture;
import pm_refactoring.inconsistencies.PMNameConflict;
import pm_refactoring.inconsistencies.PMUnknownName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMNameModel {
    HashMap<Name, String> _identifiersForNames;
    PMProject _project;

    public PMNameModel(PMProject project) {
        this._project = project;
        this._identifiersForNames = new HashMap();
        this.assignInitialIdentifiers();
    }

    public String generateNewIdentifierForName(Name name) {
        return UUID.randomUUID().toString();
    }

    private void assignInitialIdentifiers() {
        final HashMap identifiersForBindings = new HashMap();
        this._identifiersForNames = new HashMap();
        for (ASTNode rootNode : this._project.getASTRoots()) {
            rootNode.accept(new ASTVisitor(){

                public boolean visit(SimpleName simpleName) {
                    String identifier;
                    IBinding binding = simpleName.resolveBinding();
                    if (binding instanceof IVariableBinding) {
                        binding = ((IVariableBinding)binding).getVariableDeclaration();
                    }
                    if (binding instanceof ITypeBinding) {
                        binding = ((ITypeBinding)binding).getTypeDeclaration();
                    }
                    if (binding instanceof IMethodBinding) {
                        binding = ((IMethodBinding)binding).getMethodDeclaration();
                    }
                    if ((identifier = (String)identifiersForBindings.get(binding)) == null) {
                        identifier = PMNameModel.this.generateNewIdentifierForName((Name)simpleName);
                        identifiersForBindings.put(binding, identifier);
                    }
                    PMNameModel.this._identifiersForNames.put((Name)simpleName, identifier);
                    return true;
                }
            });
        }
    }

    protected ArrayList<SimpleName> nameNodesRelatedToNameNodeWithIdentifier(String identifier) {
        final String identifierCopy = identifier;
        final ArrayList<SimpleName> result = new ArrayList<SimpleName>();
        for (ASTNode rootNode : this._project.getASTRoots()) {
            rootNode.accept(new ASTVisitor(){

                public boolean visit(SimpleName visitedNode) {
                    String identifierForVisitedNode = PMNameModel.this._identifiersForNames.get(visitedNode);
                    if (identifierCopy.equals(identifierForVisitedNode)) {
                        result.add(visitedNode);
                    }
                    return true;
                }
            });
        }
        return result;
    }

    protected List<MethodDeclaration> constructorsForClass(TypeDeclaration classDeclaration) {
        ArrayList<MethodDeclaration> constructors = new ArrayList<MethodDeclaration>();
        MethodDeclaration[] methodDeclarationArray = classDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (method.isConstructor()) {
                constructors.add(method);
            }
            ++n2;
        }
        return constructors;
    }

    protected Set<SimpleName> representativeNameNodesIndirectlyRelatedToNameNode(SimpleName nameNode) {
        HashSet<SimpleName> result;
        block3: {
            MethodDeclaration method;
            ASTNode parent;
            block2: {
                result = new HashSet<SimpleName>();
                parent = nameNode.getParent();
                StructuralPropertyDescriptor locationInParent = nameNode.getLocationInParent();
                if (!(parent instanceof TypeDeclaration) || locationInParent != ((TypeDeclaration)parent).getNameProperty()) break block2;
                List<MethodDeclaration> constructors = this.constructorsForClass((TypeDeclaration)nameNode.getParent());
                for (MethodDeclaration constructor : constructors) {
                    result.add(constructor.getName());
                }
                break block3;
            }
            if (!(parent instanceof MethodDeclaration) || !(method = (MethodDeclaration)nameNode.getParent()).isConstructor()) break block3;
            TypeDeclaration containingClass = (TypeDeclaration)method.getParent();
            result.add(containingClass.getName());
            List<MethodDeclaration> constructors = this.constructorsForClass(containingClass);
            for (MethodDeclaration constructor : constructors) {
                if (constructor == method) continue;
                result.add(constructor.getName());
            }
        }
        return result;
    }

    protected void recursiveAddNameNodesRelatedToNameNode(SimpleName name, Set<SimpleName> visitedNodes) {
        String identifier = this._identifiersForNames.get(name);
        ArrayList<SimpleName> directlyRelatedNodes = this.nameNodesRelatedToNameNodeWithIdentifier(identifier);
        for (SimpleName directlyRelatedName : directlyRelatedNodes) {
            if (visitedNodes.contains(directlyRelatedName)) continue;
            visitedNodes.add(directlyRelatedName);
            Set<SimpleName> indirectlyRelatedNames = this.representativeNameNodesIndirectlyRelatedToNameNode(directlyRelatedName);
            for (SimpleName indirectlyRelatedName : indirectlyRelatedNames) {
                this.recursiveAddNameNodesRelatedToNameNode(indirectlyRelatedName, visitedNodes);
            }
        }
    }

    public ArrayList<SimpleName> nameNodesRelatedToNameNode(SimpleName name) {
        HashSet<SimpleName> allRelatedNodes = new HashSet<SimpleName>();
        this.recursiveAddNameNodesRelatedToNameNode(name, allRelatedNodes);
        return new ArrayList<SimpleName>(allRelatedNodes);
    }

    public void replaceNameWithName(Name oldName, Name newName) {
        String identifier = this.identifierForName(oldName);
        if (identifier != null) {
            this.removeIdentifierForName(oldName);
            this.setIdentifierForName(identifier, newName);
        }
    }

    public String identifierForName(Name name) {
        return this._identifiersForNames.get(name);
    }

    public String setIdentifierForName(String identifier, Name name) {
        return this._identifiersForNames.put(name, identifier);
    }

    public void removeIdentifierForName(Name name) {
        this._identifiersForNames.remove(name);
    }

    public void removeIdentifiersForTreeStartingAtNode(ASTNode rootNode) {
        rootNode.accept(new ASTVisitor(){

            public boolean visit(SimpleName simpleName) {
                PMNameModel.this.removeIdentifierForName((Name)simpleName);
                return true;
            }
        });
    }

    public Set<PMInconsistency> calculateInconsistencies() {
        HashSet<PMInconsistency> inconsistencies = new HashSet<PMInconsistency>();
        for (PMCompilationUnit pmCompilationUnit : this._project.getPMCompilationUnits()) {
            inconsistencies.addAll(this.nameInconsistenciesForICompilationUnit(pmCompilationUnit));
        }
        return inconsistencies;
    }

    private Set<PMInconsistency> nameInconsistenciesForICompilationUnit(PMCompilationUnit pmCompilationUnit) {
        HashSet<PMInconsistency> inconsistencies = new HashSet<PMInconsistency>();
        CompilationUnit compilationUnit = pmCompilationUnit.getASTNode();
        Set<SimpleName> simpleNamesInCompilationUnit = this.simpleNamesInCompilationUnit(compilationUnit);
        for (SimpleName simpleName : simpleNamesInCompilationUnit) {
            ASTNode declaringNode = this._project.findDeclaringNodeForName((Name)simpleName);
            if (declaringNode == null) continue;
            SimpleName declaringSimpleName = this._project.simpleNameForDeclaringNode(declaringNode);
            String declaringIdentifier = this.identifierForName((Name)declaringSimpleName);
            String usingIdentifier = this.identifierForName((Name)simpleName);
            if (usingIdentifier == null) {
                inconsistencies.add(new PMUnknownName(this._project, pmCompilationUnit, simpleName));
            } else if (declaringIdentifier != usingIdentifier || !declaringIdentifier.equals(usingIdentifier)) {
                inconsistencies.add(new PMNameCapture(this._project, pmCompilationUnit, (ASTNode)simpleName, null, declaringNode));
            }
            if (declaringSimpleName.getIdentifier().equals(simpleName.getIdentifier())) continue;
            inconsistencies.add(new PMNameConflict(this._project, pmCompilationUnit, simpleName, declaringSimpleName.getIdentifier()));
        }
        return inconsistencies;
    }

    private Set<SimpleName> simpleNamesInCompilationUnit(CompilationUnit compilationUnit) {
        final HashSet<SimpleName> result = new HashSet<SimpleName>();
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(SimpleName node) {
                result.add(node);
                return true;
            }
        });
        return result;
    }
}

