/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.steps;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import pm_refactoring.PMASTNodeUtils;
import pm_refactoring.PMNodeReference;
import pm_refactoring.PMProject;
import pm_refactoring.analysis.PMDef;
import pm_refactoring.analysis.PMRDefsAnalysis;
import pm_refactoring.analysis.PMUse;
import pm_refactoring.models.PMNameModel;
import pm_refactoring.models.PMUDModel;
import pm_refactoring.steps.PMStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMSplitStep
extends PMStep {
    ICompilationUnit _iCompilationUnit;
    ExpressionStatement _assignmentStatement;
    VariableDeclarationStatement _replacementDeclarationStatement;
    Expression _initializer;
    Expression _initializerCopy;
    PMNodeReference _replacementDeclarationReference;

    public PMSplitStep(PMProject project, ExpressionStatement assignmentStatement) {
        super(project);
        this._assignmentStatement = assignmentStatement;
        CompilationUnit containingCompilationUnit = (CompilationUnit)this._assignmentStatement.getRoot();
        this._iCompilationUnit = (ICompilationUnit)containingCompilationUnit.getJavaElement();
    }

    public VariableDeclarationStatement getReplacementDeclarationStatement() {
        return (VariableDeclarationStatement)this._replacementDeclarationReference.getNode();
    }

    public void rewriteToReplaceAssignmentStatementWithDeclaration(ASTRewrite rewrite, Assignment assignment) {
        SimpleName lhs = (SimpleName)assignment.getLeftHandSide();
        AST ast = assignment.getAST();
        this._initializer = assignment.getRightHandSide();
        this._initializerCopy = (Expression)ASTNode.copySubtree((AST)ast, (ASTNode)this._initializer);
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setInitializer(this._initializerCopy);
        fragment.setName(ast.newSimpleName(lhs.getIdentifier()));
        this._replacementDeclarationStatement = ast.newVariableDeclarationStatement(fragment);
        VariableDeclaration originalVariableDeclaration = PMASTNodeUtils.localVariableDeclarationForSimpleName(lhs);
        Type type = null;
        if (originalVariableDeclaration instanceof VariableDeclarationFragment) {
            ASTNode parent = originalVariableDeclaration.getParent();
            if (parent instanceof VariableDeclarationStatement) {
                type = ((VariableDeclarationStatement)parent).getType();
            } else if (parent instanceof VariableDeclarationExpression) {
                type = ((VariableDeclarationExpression)parent).getType();
            }
        } else if (originalVariableDeclaration instanceof SingleVariableDeclaration) {
            type = ((SingleVariableDeclaration)originalVariableDeclaration).getType();
        }
        this._replacementDeclarationStatement.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)type));
        rewrite.replace((ASTNode)this._assignmentStatement, (ASTNode)this._replacementDeclarationStatement, null);
    }

    public void rewriteToRenameSimpleNameToIdentifier(ASTRewrite rewrite, SimpleName simpleName, String identifier) {
        rewrite.set((ASTNode)simpleName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)identifier, null);
    }

    public MethodDeclaration findContainingMethodDeclaration(ASTNode node) {
        MethodDeclaration containingMethodDeclaration = null;
        ASTNode iterator = node;
        while ((iterator = iterator.getParent()) != null) {
            if (!(iterator instanceof MethodDeclaration)) continue;
            containingMethodDeclaration = (MethodDeclaration)iterator;
        }
        return containingMethodDeclaration;
    }

    @Override
    public Map<ICompilationUnit, ASTRewrite> calculateTextualChange() {
        ASTRewrite astRewrite = ASTRewrite.create((AST)this._assignmentStatement.getAST());
        Assignment assignmentExpression = (Assignment)this._assignmentStatement.getExpression();
        this.rewriteToReplaceAssignmentStatementWithDeclaration(astRewrite, assignmentExpression);
        HashMap<ICompilationUnit, ASTRewrite> result = new HashMap<ICompilationUnit, ASTRewrite>();
        result.put(this._iCompilationUnit, astRewrite);
        return result;
    }

    @Override
    public void performASTChange() {
        Assignment oldAssignmentExpression = (Assignment)this._assignmentStatement.getExpression();
        MethodDeclaration containingMethodDeclaration = this.findContainingMethodDeclaration((ASTNode)oldAssignmentExpression);
        PMRDefsAnalysis reachingDefsAnalysis = new PMRDefsAnalysis(containingMethodDeclaration);
        PMDef definitionForAssignment = reachingDefsAnalysis.getDefinitionForDefiningNode((ASTNode)oldAssignmentExpression);
        HashSet<SimpleName> uses = new HashSet<SimpleName>();
        for (PMUse use : definitionForAssignment.getUses()) {
            SimpleName usingSimpleName = use.getSimpleName();
            uses.add(usingSimpleName);
        }
        VariableDeclarationFragment newVariableDeclarationFragment = (VariableDeclarationFragment)this._replacementDeclarationStatement.fragments().get(0);
        PMNodeReference identifierForOldAssignment = this._project.getReferenceForNode((ASTNode)oldAssignmentExpression);
        this._project.recursivelyReplaceNodeWithCopy((ASTNode)this._initializer, (ASTNode)this._initializerCopy);
        PMNodeReference identifierForNewVariableDeclaration = this._project.getReferenceForNode((ASTNode)newVariableDeclarationFragment);
        SimpleName oldLHS = (SimpleName)oldAssignmentExpression.getLeftHandSide();
        SimpleName newLHS = newVariableDeclarationFragment.getName();
        PMUDModel udModel = this._project.getUDModel();
        for (PMNodeReference useIdentifier : new HashSet<PMNodeReference>(udModel.usesForDefinition(identifierForOldAssignment))) {
            udModel.removeDefinitionIdentifierForName(identifierForOldAssignment, useIdentifier);
            udModel.addDefinitionIdentifierForName(identifierForNewVariableDeclaration, useIdentifier);
        }
        udModel.deleteDefinition(identifierForOldAssignment);
        PMNameModel nameModel = this._project.getNameModel();
        nameModel.removeIdentifierForName((Name)oldLHS);
        String freshIdentifier = UUID.randomUUID().toString();
        nameModel.setIdentifierForName(freshIdentifier, (Name)newLHS);
        for (SimpleName use : uses) {
            nameModel.setIdentifierForName(freshIdentifier, (Name)use);
        }
        StructuralPropertyDescriptor location = this._assignmentStatement.getLocationInParent();
        List parentList = (List)this._assignmentStatement.getParent().getStructuralProperty(location);
        parentList.set(parentList.indexOf(this._assignmentStatement), this._replacementDeclarationStatement);
        this._replacementDeclarationReference = this._project.getReferenceForNode((ASTNode)this._replacementDeclarationStatement);
    }

    @Override
    public void updateAfterReparse() {
    }

    @Override
    public void cleanup() {
    }
}

