/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.steps;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.TextEdit;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMStep {
    PMProject _project;

    PMStep(PMProject project) {
        this._project = project;
    }

    public Map<ICompilationUnit, ASTRewrite> calculateTextualChange() {
        return null;
    }

    public void performASTChange() {
    }

    public void updateAfterReparse() {
    }

    public void cleanup() {
    }

    public void applyAllAtOnce() {
        Map<ICompilationUnit, ASTRewrite> rewrites = this.calculateTextualChange();
        for (ICompilationUnit compilationUnitToRewrite : rewrites.keySet()) {
            PMWorkspace.applyRewrite(rewrites.get(compilationUnitToRewrite), compilationUnitToRewrite);
        }
        this.performASTChange();
        this._project.updateToNewVersionsOfICompilationUnits();
        this.updateAfterReparse();
        this.cleanup();
        this._project.rescanForInconsistencies();
    }

    public Change createCompositeChange(String changeDescription) {
        Map<ICompilationUnit, ASTRewrite> rewrites = this.calculateTextualChange();
        Object result = new NullChange();
        try {
            if (rewrites.size() > 0) {
                PMCompositeChange combinedChange = new PMCompositeChange(changeDescription);
                for (ICompilationUnit compilationUnitToChange : rewrites.keySet()) {
                    ASTRewrite rewrite = rewrites.get(compilationUnitToChange);
                    TextEdit astEdit = rewrite.rewriteAST();
                    PMTextFileChange localChange = new PMTextFileChange(changeDescription, (IFile)compilationUnitToChange.getResource());
                    localChange.setTextType("java");
                    localChange.setEdit(astEdit);
                    combinedChange.add((Change)localChange);
                }
                result = combinedChange;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public class PMCompositeChange
    extends CompositeChange {
        public PMCompositeChange(String name) {
            super(name);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Change result = super.perform(pm);
            PMStep.this.performASTChange();
            PMStep.this._project.updateToNewVersionsOfICompilationUnits();
            PMStep.this.updateAfterReparse();
            PMStep.this.cleanup();
            PMStep.this._project.rescanForInconsistencies();
            return result;
        }
    }

    public class PMTextFileChange
    extends TextFileChange {
        public PMTextFileChange(String name, IFile file) {
            super(name, file);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Change result = super.perform(pm);
            return result;
        }
    }
}

