/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.tests.PMTest;

public class EclipseIssuesTest
extends PMTest {
    @Test
    public void testImpreciseBindingsKeysForDuplicateLocalVariables() {
        String source = "public class S {void m(){int x; x++; int x; x--;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        SimpleName firstX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 0, "m", 0, "S", 0, compilationUnit);
        SimpleName secondX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 1, "m", 0, "S", 0, compilationUnit);
        SimpleName thirdX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 2, "m", 0, "S", 0, compilationUnit);
        SimpleName fourthX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 3, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals((Object)firstX.resolveBinding().getKey(), (Object)thirdX.resolveBinding().getKey());
        Assert.assertTrue((firstX.resolveBinding().hashCode() != thirdX.resolveBinding().hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstX.resolveBinding(), (Object)secondX.resolveBinding());
        Assert.assertEquals((Object)thirdX.resolveBinding(), (Object)fourthX.resolveBinding());
    }

    @Test
    public void testNoBindingsKeysForDuplicateFields() {
        String source = "public class S {int x; int x; void m(){x++;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        VariableDeclarationFragment firstXField = PMASTQuery.fieldWithNameInClassInCompilationUnit("x", 0, "S", 0, compilationUnit);
        Assert.assertTrue((firstXField != null ? 1 : 0) != 0);
        VariableDeclarationFragment secondXField = PMASTQuery.fieldWithNameInClassInCompilationUnit("x", 1, "S", 0, compilationUnit);
        Assert.assertTrue((secondXField != null ? 1 : 0) != 0);
        SimpleName firstLocalX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertTrue((firstLocalX.resolveBinding() == null ? 1 : 0) != 0);
    }
}

