/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTMatcher;
import pm_refactoring.PMASTQuery;

public class PMASTMatcherTest {
    @Test
    public void testMatchIsomorphicSimpleNames() {
        AST ast = AST.newAST((int)3);
        SimpleName foo1 = ast.newSimpleName("Foo");
        SimpleName foo2 = ast.newSimpleName("Foo");
        PMASTMatcher matcher = new PMASTMatcher((ASTNode)foo1, (ASTNode)foo2);
        Assert.assertTrue((boolean)matcher.match());
        Assert.assertEquals((Object)1, (Object)matcher.isomorphicNodes().size());
        Assert.assertSame((Object)matcher.isomorphicNodes().get(foo1), (Object)foo2);
    }

    @Test
    public void testMatchNonIsomorphicSimpleNames() {
        AST ast = AST.newAST((int)3);
        SimpleName foo = ast.newSimpleName("Foo");
        SimpleName bar = ast.newSimpleName("Bar");
        PMASTMatcher matcher = new PMASTMatcher((ASTNode)foo, (ASTNode)bar);
        Assert.assertFalse((boolean)matcher.match());
        Assert.assertEquals((Object)0, (Object)matcher.isomorphicNodes().size());
    }

    @Test
    public void testMatchIsomorphicCompilationUnits() {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource("public class S { void m() {int x; x++; int y; y++;} }".toCharArray());
        CompilationUnit compilationUnit1 = (CompilationUnit)parser.createAST(null);
        parser.setSource("public class S { void m() {int x; x++; int y; y++;} }".toCharArray());
        CompilationUnit compilationUnit2 = (CompilationUnit)parser.createAST(null);
        PMASTMatcher matcher = new PMASTMatcher((ASTNode)compilationUnit1, (ASTNode)compilationUnit2);
        Assert.assertTrue((boolean)matcher.match());
        Map<ASTNode, ASTNode> isomorphicNodes = matcher.isomorphicNodes();
        Assert.assertSame((Object)isomorphicNodes.get(compilationUnit1), (Object)compilationUnit2);
        SimpleName secondY1 = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 1, "m", 0, "S", 0, compilationUnit1);
        SimpleName secondY2 = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 1, "m", 0, "S", 0, compilationUnit2);
        Assert.assertNotNull((Object)isomorphicNodes.get(secondY1));
        Assert.assertSame((Object)isomorphicNodes.get(secondY1), (Object)secondY2);
        Assert.assertNotNull((Object)isomorphicNodes.get(secondY1.getParent()));
        Assert.assertSame((Object)isomorphicNodes.get(secondY1.getParent()), (Object)secondY2.getParent());
        Assert.assertNotNull((Object)isomorphicNodes.get(secondY1.getParent().getParent()));
        Assert.assertSame((Object)isomorphicNodes.get(secondY1.getParent().getParent()), (Object)secondY2.getParent().getParent());
        Assert.assertNotNull((Object)isomorphicNodes.get(secondY1.getParent().getParent().getParent()));
        Assert.assertSame((Object)isomorphicNodes.get(secondY1.getParent().getParent().getParent()), (Object)secondY2.getParent().getParent().getParent());
        Assert.assertNotNull((Object)isomorphicNodes.get(secondY1.getParent().getParent().getParent().getParent()));
        Assert.assertSame((Object)isomorphicNodes.get(secondY1.getParent().getParent().getParent().getParent()), (Object)secondY2.getParent().getParent().getParent().getParent());
    }

    @Test
    public void testMatchNonIsomorphicInSimplePropertyCompilationUnits() {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource("public class S { void m() {int x; x++; int y; y++;} }".toCharArray());
        CompilationUnit compilationUnit1 = (CompilationUnit)parser.createAST(null);
        parser.setSource("public class S { void m() {int x; x++; int y; x++;} }".toCharArray());
        CompilationUnit compilationUnit2 = (CompilationUnit)parser.createAST(null);
        PMASTMatcher matcher = new PMASTMatcher((ASTNode)compilationUnit1, (ASTNode)compilationUnit2);
        Assert.assertFalse((boolean)matcher.match());
    }

    @Test
    public void testMatchNonIsomorphicInChildListPropertyCompilationUnits() {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource("public class S { void m() {int x; x++; int y; y++;} }".toCharArray());
        CompilationUnit compilationUnit1 = (CompilationUnit)parser.createAST(null);
        parser.setSource("public class S { void m() {int x; x++; int y;} }".toCharArray());
        CompilationUnit compilationUnit2 = (CompilationUnit)parser.createAST(null);
        PMASTMatcher matcher = new PMASTMatcher((ASTNode)compilationUnit1, (ASTNode)compilationUnit2);
        Assert.assertFalse((boolean)matcher.match());
    }
}

