/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.PMNodeReference;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.models.PMNameModel;
import pm_refactoring.models.PMUDModel;
import pm_refactoring.steps.PMCopyStep;
import pm_refactoring.tests.PMTest;

public class PMCopyStepTest
extends PMTest {
    @Test
    public void testCopyFieldCreatesNewNameIdentifier() throws JavaModelException {
        String source = "public class S {int x; void m(){x = 1;}}";
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        VariableDeclarationFragment fieldDeclarationFragment = PMASTQuery.fieldWithNameInClassInCompilationUnit("x", 0, "S", 0, (CompilationUnit)pmProject.findASTRootForICompilationUnit(iCompilationUnit));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)fieldDeclarationFragment.getParent();
        SimpleName fieldDeclarationOriginalName = ((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).getName();
        String fieldDeclarationOriginalNameIdentifier = pmProject.getNameModel().identifierForName((Name)fieldDeclarationOriginalName);
        PMCopyStep copyStep = new PMCopyStep(pmProject, (ASTNode)fieldDeclaration);
        copyStep.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {int x; void m(){x = 1;}}", iCompilationUnit.getSource()));
        FieldDeclaration fieldDeclarationCopy = (FieldDeclaration)pmProject.getPasteboard().getPasteboardRoots().get(0);
        Assert.assertNotNull((Object)fieldDeclarationCopy);
        SimpleName fieldDeclarationCopyName = ((VariableDeclarationFragment)fieldDeclarationCopy.fragments().get(0)).getName();
        String fieldDeclarationCopyNameIdentifier = pmProject.getNameModel().identifierForName((Name)fieldDeclarationCopyName);
        Assert.assertNotNull((Object)fieldDeclarationCopyNameIdentifier);
        Assert.assertFalse((boolean)fieldDeclarationCopyNameIdentifier.equals(fieldDeclarationOriginalNameIdentifier));
    }

    @Test
    public void testCopyDeclarationAndReferencesMaintainsInternalReferences() throws JavaModelException {
        String source = "public class S {int x; void m(){x = 1; y++;} int y;}";
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMNameModel nameModel = pmProject.getNameModel();
        CompilationUnit compilationUnitS = (CompilationUnit)pmProject.findASTRootForICompilationUnit(iCompilationUnit);
        FieldDeclaration fieldDeclaration = (FieldDeclaration)PMASTQuery.fieldWithNameInClassInCompilationUnit("x", 0, "S", 0, compilationUnitS).getParent();
        SimpleName fieldDeclarationOriginalName = ((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).getName();
        String fieldDeclarationOriginalNameIdentifier = nameModel.identifierForName((Name)fieldDeclarationOriginalName);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnitS);
        SimpleName methodDeclarationOriginalName = methodDeclaration.getName();
        String methodDeclarationOriginalNameIdentifier = nameModel.identifierForName((Name)methodDeclarationOriginalName);
        SimpleName originalUseOfYInM = PMASTQuery.simpleNameWithIdentifierInNode("y", 0, (ASTNode)methodDeclaration.getBody());
        String originalUseOfYInMIdentifier = nameModel.identifierForName((Name)originalUseOfYInM);
        ArrayList<ASTNode> nodesToCopy = new ArrayList<ASTNode>();
        nodesToCopy.add((ASTNode)methodDeclaration);
        nodesToCopy.add((ASTNode)fieldDeclaration);
        PMCopyStep copyStep = new PMCopyStep(pmProject, nodesToCopy);
        copyStep.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {int x; void m(){x = 1; y++;} int y;}", iCompilationUnit.getSource()));
        MethodDeclaration methodDeclarationCopy = (MethodDeclaration)pmProject.getPasteboard().getPasteboardRoots().get(0);
        FieldDeclaration fieldDeclarationCopy = (FieldDeclaration)pmProject.getPasteboard().getPasteboardRoots().get(1);
        Assert.assertNotNull((Object)fieldDeclarationCopy);
        SimpleName fieldDeclarationCopyName = ((VariableDeclarationFragment)fieldDeclarationCopy.fragments().get(0)).getName();
        String fieldDeclarationCopyNameIdentifier = nameModel.identifierForName((Name)fieldDeclarationCopyName);
        Assert.assertNotNull((Object)fieldDeclarationCopyNameIdentifier);
        Assert.assertFalse((boolean)fieldDeclarationCopyNameIdentifier.equals(fieldDeclarationOriginalNameIdentifier));
        String methodDeclarationCopyNameIdentifier = nameModel.identifierForName((Name)methodDeclarationCopy.getName());
        Assert.assertNotNull((Object)methodDeclarationCopyNameIdentifier);
        Assert.assertFalse((boolean)methodDeclarationCopyNameIdentifier.equals(methodDeclarationOriginalNameIdentifier));
        SimpleName copyUseOfXInM = PMASTQuery.simpleNameWithIdentifierInNode("x", 0, (ASTNode)methodDeclarationCopy.getBody());
        String copyUseOfXInMIdentifier = nameModel.identifierForName((Name)copyUseOfXInM);
        Assert.assertEquals((Object)copyUseOfXInMIdentifier, (Object)fieldDeclarationCopyNameIdentifier);
        SimpleName copyUseOfYInM = PMASTQuery.simpleNameWithIdentifierInNode("y", 0, (ASTNode)methodDeclarationCopy.getBody());
        String copyUseOfYInMIdentifier = nameModel.identifierForName((Name)copyUseOfYInM);
        Assert.assertEquals((Object)copyUseOfYInMIdentifier, (Object)originalUseOfYInMIdentifier);
    }

    @Test
    public void testCopyDefinitionAndReferencesMaintainsInternalReferences() throws JavaModelException {
        String source = "public class S {void m(){int x = 1; int y = 2; int z = 3; x = x + 1; z = y + x;}}";
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMUDModel udModel = pmProject.getUDModel();
        CompilationUnit compilationUnitS = (CompilationUnit)pmProject.findASTRootForICompilationUnit(iCompilationUnit);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnitS);
        ExpressionStatement fourthStatementOriginal = (ExpressionStatement)methodDeclaration.getBody().statements().get(3);
        Assignment xGetsXPlusOneAssignmentOriginal = (Assignment)fourthStatementOriginal.getExpression();
        SimpleName x3RHSOriginal = PMASTQuery.simpleNameWithIdentifierInNode("x", 1, (ASTNode)xGetsXPlusOneAssignmentOriginal);
        PMNodeReference x3RHSOriginalNodeReference = pmProject.getReferenceForNode((ASTNode)x3RHSOriginal);
        ExpressionStatement fifthStatementOriginal = (ExpressionStatement)methodDeclaration.getBody().statements().get(4);
        ArrayList<ASTNode> nodesToCopy = new ArrayList<ASTNode>();
        nodesToCopy.add((ASTNode)fifthStatementOriginal);
        nodesToCopy.add((ASTNode)fourthStatementOriginal);
        PMCopyStep copyStep = new PMCopyStep(pmProject, nodesToCopy);
        copyStep.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource(source, iCompilationUnit.getSource()));
        ExpressionStatement fourthStatementCopy = (ExpressionStatement)pmProject.getPasteboard().getPasteboardRoots().get(1);
        Assert.assertNotNull((Object)fourthStatementCopy);
        ExpressionStatement fifthStatementCopy = (ExpressionStatement)pmProject.getPasteboard().getPasteboardRoots().get(0);
        Assert.assertNotNull((Object)fifthStatementCopy);
        Assignment xGetsXPlusOneAssignmentCopy = (Assignment)fourthStatementCopy.getExpression();
        PMNodeReference xGetsXPlusOneAssignmentCopyReference = pmProject.getReferenceForNode((ASTNode)xGetsXPlusOneAssignmentCopy);
        SimpleName x3RHSCopy = PMASTQuery.simpleNameWithIdentifierInNode("x", 1, (ASTNode)xGetsXPlusOneAssignmentCopy);
        PMNodeReference x3RHSCopyNodeReference = pmProject.getReferenceForNode((ASTNode)x3RHSCopy);
        Set<PMNodeReference> definitionsForX3RHSOriginal = udModel.definitionIdentifiersForName(x3RHSOriginalNodeReference);
        Set<PMNodeReference> definitionsForX3RHSCopy = udModel.definitionIdentifiersForName(x3RHSCopyNodeReference);
        Assert.assertEquals(definitionsForX3RHSOriginal, definitionsForX3RHSCopy);
        SimpleName x4RHSCopy = PMASTQuery.simpleNameWithIdentifierInNode("x", 0, (ASTNode)fifthStatementCopy);
        PMNodeReference x4RHSCopyNodeReference = pmProject.getReferenceForNode((ASTNode)x4RHSCopy);
        Set<PMNodeReference> definitionsForX4RHSCopy = udModel.definitionIdentifiersForName(x4RHSCopyNodeReference);
        Assert.assertEquals((Object)1, (Object)definitionsForX4RHSCopy.size());
        Assert.assertEquals((Object)xGetsXPlusOneAssignmentCopyReference, (Object)definitionsForX4RHSCopy.toArray()[0]);
    }
}

