/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMDelegateProcessor;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.inconsistencies.PMInconsistency;
import pm_refactoring.tests.PMProcessorDriver;
import pm_refactoring.tests.PMTest;

public class PMDelegateProcessorTest
extends PMTest {
    @Test
    public void testAddDelegateToSimpleMethodInvocation() throws JavaModelException {
        String source = "public class S {void m(){S s = new S();s.getClass(); m();}}";
        ICompilationUnit compilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMDelegateProcessor delegateProcessor = new PMDelegateProcessor((ITextSelection)new TextSelection(53, 3), compilationUnit);
        delegateProcessor.setDelegateIdentifier("s");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMProcessorDriver.drive(delegateProcessor);
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {void m(){S s = new S();s.getClass(); s.m();}}", compilationUnit.getSource()));
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertEquals((Object)0, (Object)inconsistencies.size());
    }

    @Test
    public void testAddSuperDelegateToSimpleMethodInvocation() throws JavaModelException {
        String source = "public class S {void m(){S s; m();}}";
        ICompilationUnit compilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMDelegateProcessor delegateProcessor = new PMDelegateProcessor((ITextSelection)new TextSelection(30, 3), compilationUnit);
        delegateProcessor.setDelegateIdentifier("super");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMProcessorDriver.drive(delegateProcessor);
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {void m(){S s; super.m();}}", compilationUnit.getSource()));
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertEquals((Object)0, (Object)inconsistencies.size());
    }

    @Test
    public void testRemoveDelegateFromSimpleMethodInvocation() throws JavaModelException {
        String source = "public class S {void m(){S s; s.m();}}";
        ICompilationUnit compilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMDelegateProcessor delegateProcessor = new PMDelegateProcessor((ITextSelection)new TextSelection(30, 5), compilationUnit);
        delegateProcessor.setDelegateIdentifier("");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        RefactoringStatus status = PMProcessorDriver.drive(delegateProcessor);
        Assert.assertTrue((status.getSeverity() < 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {void m(){S s; m();}}", compilationUnit.getSource()));
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertEquals((Object)0, (Object)inconsistencies.size());
    }

    @Test
    public void testDelegateToField() throws JavaModelException {
        String source = "public class S {S s; void m(){s.getClass(); m();}}";
        ICompilationUnit compilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMDelegateProcessor delegateProcessor = new PMDelegateProcessor((ITextSelection)new TextSelection(44, 3), compilationUnit);
        delegateProcessor.setDelegateIdentifier("s");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMProcessorDriver.drive(delegateProcessor);
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {S s; void m(){s.getClass(); s.m();}}", compilationUnit.getSource()));
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertEquals((Object)0, (Object)inconsistencies.size());
    }

    @Test
    public void testDelegateToFieldInSuperClassWithPackages() throws JavaModelException {
        String subSource = "package t; public class Sub extends Super {void g() {m();}}";
        ICompilationUnit subCompilationUnit = this.createNewCompilationUnit("t", "Sub.java", subSource);
        PMDelegateProcessor delegateProcessor = new PMDelegateProcessor((ITextSelection)new TextSelection(53, 3), subCompilationUnit);
        delegateProcessor.setDelegateIdentifier("s");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMProcessorDriver.drive(delegateProcessor);
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("package t; public class Sub extends Super {void g() {s.m();}}", subCompilationUnit.getSource()));
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertEquals((Object)0, (Object)inconsistencies.size());
    }
}

