/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.PMCompilationUnit;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.inconsistencies.PMInconsistency;
import pm_refactoring.steps.PMDelegateStep;
import pm_refactoring.tests.PMTest;

public class PMDelegateStepTest
extends PMTest {
    @Test
    public void testDelegateWithNameCapture() {
        String source1 = "public class S1 { void m(){/*S1*/}}";
        String source2 = "public class S2 {void m(){/*S2*/} void b(){S1 s1; m();} }";
        this.createNewCompilationUnit("", "S1.java", source1);
        ICompilationUnit compilationUnit2 = this.createNewCompilationUnit("", "S2.java", source2);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMCompilationUnit s2PMCompilationUnit = pmProject.getPMCompilationUnitForICompilationUnit(compilationUnit2);
        MethodDeclaration methodB = PMASTQuery.methodWithNameInClassInCompilationUnit("b", 0, "S2", 0, s2PMCompilationUnit.getASTNode());
        ExpressionStatement methodInvocationStatement = (ExpressionStatement)methodB.getBody().statements().get(1);
        MethodInvocation callToB = (MethodInvocation)methodInvocationStatement.getExpression();
        PMDelegateStep step = new PMDelegateStep(pmProject, (ASTNode)callToB);
        step.setDelegateIdentifier("s1");
        step.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S2 {void m(){/*S2*/} void b(){S1 s1; s1.m();} }", s2PMCompilationUnit.getSource()));
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertEquals((Object)1, (Object)inconsistencies.size());
    }
}

