/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.selection.PMInsertionPoint;
import pm_refactoring.selection.PMSelection;
import pm_refactoring.tests.PMTest;

public class PMSelectionTest
extends PMTest {
    @Test
    public void testSelectStatement() {
        String source = "class S {int x,y; int f() {int x,y; while(1) {x = 5; y = x +1;} } }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        PMSelection whileSelection = new PMSelection(compilationUnit, 36, 27);
        ASTNode selectedNode = whileSelection.singleSelectedNode();
        Assert.assertTrue((selectedNode != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(selectedNode instanceof WhileStatement));
    }

    @Test
    public void testSelectStatements() {
        String source = "class S {void f(int i) {int x,y; f(x); x++; } }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        PMSelection selectionObject = new PMSelection(compilationUnit, 33, 10);
        Assert.assertNull((Object)selectionObject.singleSelectedNode());
        Assert.assertTrue((boolean)(selectionObject.selectedNodeParent() instanceof Block));
        Assert.assertEquals((Object)Block.STATEMENTS_PROPERTY, (Object)selectionObject.selectedNodeParentProperty());
        Assert.assertEquals((Object)1, (Object)selectionObject.selectedNodeParentPropertyListOffset());
        Assert.assertEquals((Object)2, (Object)selectionObject.selectedNodeParentPropertyListLength());
        Assert.assertTrue((boolean)selectionObject.isListSelection());
        Assert.assertTrue((boolean)selectionObject.isMultipleSelection());
    }

    @Test
    public void testSelectMethodInvocation() {
        String source = "class S {void f(int i) {int x,y; f(x); } }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        PMSelection selectionObject = new PMSelection(compilationUnit, 33, 4);
        ASTNode selectedNode = selectionObject.singleSelectedNode();
        Assert.assertTrue((selectedNode != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(selectedNode instanceof MethodInvocation));
    }

    @Test
    public void testSelectMemberDeclaration() {
        String source = "class S {int x,y; void f(int i) {int x,y; f(x); } int z; }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        PMSelection selectionObject = new PMSelection(compilationUnit, 9, 8);
        ASTNode selectedNode = selectionObject.singleSelectedNode();
        Assert.assertTrue((boolean)(selectedNode instanceof FieldDeclaration));
        selectionObject = new PMSelection(compilationUnit, 18, 31);
        selectedNode = selectionObject.singleSelectedNode();
        Assert.assertTrue((boolean)(selectedNode instanceof MethodDeclaration));
        selectionObject = new PMSelection(compilationUnit, 50, 6);
        selectedNode = selectionObject.singleSelectedNode();
        Assert.assertTrue((boolean)(selectedNode instanceof FieldDeclaration));
    }

    @Test
    public void testSelectMemberDeclarations() {
        String source = "class S {int x; void f(int i) {int x,y; f(x); x++; } int y;}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        PMSelection selectionObject = new PMSelection(compilationUnit, 9, 44);
        Assert.assertNull((Object)selectionObject.singleSelectedNode());
        Assert.assertTrue((boolean)(selectionObject.selectedNodeParent() instanceof TypeDeclaration));
        Assert.assertEquals((Object)TypeDeclaration.BODY_DECLARATIONS_PROPERTY, (Object)selectionObject.selectedNodeParentProperty());
        Assert.assertEquals((Object)0, (Object)selectionObject.selectedNodeParentPropertyListOffset());
        Assert.assertEquals((Object)2, (Object)selectionObject.selectedNodeParentPropertyListLength());
        Assert.assertTrue((boolean)selectionObject.isListSelection());
        Assert.assertTrue((boolean)selectionObject.isMultipleSelection());
    }

    @Test
    public void testSelectStatementWithSurroundingWhitespace() {
        String source = "class S {void f() {int x,y; f(); x++;} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        PMSelection selectionObject = new PMSelection(compilationUnit, 28, 5);
        ASTNode selectedNode = selectionObject.singleSelectedNode();
        Assert.assertTrue((boolean)(selectedNode instanceof Statement));
    }

    @Test
    public void testNoneSaneSelection() {
        String source = "class S {void f() {int x,y; f(); x++;} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        PMSelection selectionObject = new PMSelection(compilationUnit, 33, 2);
        Assert.assertNull((Object)selectionObject.singleSelectedNode());
        Assert.assertFalse((boolean)selectionObject.isSaneSelection());
    }

    @Test
    public void testSelectSimpleName() {
        String source = "class S {void f() {int x,y; f(); x++;} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        PMSelection selectionObject = new PMSelection(compilationUnit, 23, 1);
        Assert.assertTrue((boolean)(selectionObject.singleSelectedNode() instanceof SimpleName));
        Assert.assertFalse((boolean)selectionObject.isSaneSelection());
    }

    @Test
    public void testInsertionIndexAtBeginningOfBlock() {
        String source = "class S {void f() {int x,y; f(); x++;} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 19);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        ASTNode insertionParent = insertionPointDescriptor.insertionParent();
        Assert.assertTrue((boolean)(insertionParent instanceof Block));
        Assert.assertEquals((Object)0, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)Block.STATEMENTS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
    }

    @Test
    public void testInsertionIndexInMiddleOfBlock() {
        String source = "class S {void f() {int x,y; f(); x++;} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 27);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        ASTNode insertionParent = insertionPointDescriptor.insertionParent();
        Assert.assertTrue((boolean)(insertionParent instanceof Block));
        Assert.assertEquals((Object)1, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)Block.STATEMENTS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
    }

    @Test
    public void testInsertionIndexAtEndOfBlock() {
        String source = "class S {void f() {int x,y; f(); x++;} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 37);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        ASTNode insertionParent = insertionPointDescriptor.insertionParent();
        Assert.assertTrue((boolean)(insertionParent instanceof Block));
        Assert.assertEquals((Object)3, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)Block.STATEMENTS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
    }

    @Test
    public void testNonSaneInsertionPointInMiddleOfStatement() {
        String source = "class S {void f() {int x,y; f(); x++;} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 35);
        Assert.assertTrue((!insertionPointDescriptor.isSaneInsertionPoint() ? 1 : 0) != 0);
        Assert.assertNull((Object)insertionPointDescriptor.insertionParent());
        Assert.assertEquals((Object)-1, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertNull((Object)insertionPointDescriptor.insertionProperty());
    }

    @Test
    public void testInsertionIndexAtBeginningOfBodyDeclarationsList() {
        String source = "class S {int a; void f() {int x,y; f(); x++;} int b;}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 9);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        ASTNode insertionParent = insertionPointDescriptor.insertionParent();
        Assert.assertTrue((boolean)(insertionParent instanceof AbstractTypeDeclaration));
        Assert.assertEquals((Object)0, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)TypeDeclaration.BODY_DECLARATIONS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
    }

    @Test
    public void testInsertionIndexInMiddleOfBodyDeclarationsList() {
        String source = "class S {int a; void f() {int x,y; f(); x++;} int b;}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 15);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        ASTNode insertionParent = insertionPointDescriptor.insertionParent();
        Assert.assertTrue((boolean)(insertionParent instanceof TypeDeclaration));
        Assert.assertEquals((Object)1, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)TypeDeclaration.BODY_DECLARATIONS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
    }

    @Test
    public void testInsertionIndexAtEndOfBodyDeclarationsList() {
        String source = "class S {int a; void f() {int x,y; f(); x++;} int b;}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 52);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        ASTNode insertionParent = insertionPointDescriptor.insertionParent();
        Assert.assertTrue((boolean)(insertionParent instanceof TypeDeclaration));
        Assert.assertEquals((Object)3, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)TypeDeclaration.BODY_DECLARATIONS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
    }

    @Test
    public void testInsertionIndexInBodyDeclarationsListNotDirectlyOnEdge() {
        String source = "class S {  int a;  int b;  int c;  }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 10);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        Assert.assertTrue((boolean)(insertionPointDescriptor.insertionParent() instanceof TypeDeclaration));
        Assert.assertEquals((Object)0, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)TypeDeclaration.BODY_DECLARATIONS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
        insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 18);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        Assert.assertTrue((boolean)(insertionPointDescriptor.insertionParent() instanceof TypeDeclaration));
        Assert.assertEquals((Object)1, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)TypeDeclaration.BODY_DECLARATIONS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
        insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 26);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        Assert.assertTrue((boolean)(insertionPointDescriptor.insertionParent() instanceof TypeDeclaration));
        Assert.assertEquals((Object)2, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)TypeDeclaration.BODY_DECLARATIONS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
        insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 34);
        Assert.assertTrue((boolean)insertionPointDescriptor.isSaneInsertionPoint());
        Assert.assertTrue((boolean)(insertionPointDescriptor.insertionParent() instanceof TypeDeclaration));
        Assert.assertEquals((Object)3, (Object)insertionPointDescriptor.insertionIndex());
        Assert.assertEquals((Object)TypeDeclaration.BODY_DECLARATIONS_PROPERTY, (Object)insertionPointDescriptor.insertionProperty());
    }

    @Test
    public void testNonSaneInsertionPointInIfGuardCondition() {
        String source = "class S { void m() {if (true) { } }  }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        PMInsertionPoint insertionPointDescriptor = new PMInsertionPoint(compilationUnit, 26);
        Assert.assertFalse((boolean)insertionPointDescriptor.isSaneInsertionPoint());
    }
}

